/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.torque.om.BaseTorqueBasicGroupPeer;
import org.apache.fulcrum.security.torque.om.TorqueBasicGroup;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.MappingStrategy;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.UniqueColumnList;

public class BaseTorqueBasicGroupRecordMapper
implements RecordMapper<TorqueBasicGroup> {
    private static final long serialVersionUID = 1735909173126L;
    private static Log log = LogFactory.getLog(BaseTorqueBasicGroupRecordMapper.class);
    private static final String GROUP_ID_EXPRESSION = BaseTorqueBasicGroupPeer.GROUP_ID.getSqlExpression();
    private static final String GROUP_NAME_EXPRESSION = BaseTorqueBasicGroupPeer.GROUP_NAME.getSqlExpression();
    private boolean useMappingStrategy = true;
    private MappingStrategy<TorqueBasicGroup> strategy;

    public void initStrategy() {
        this.strategy = new MappingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorqueBasicGroup processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        TorqueBasicGroup torqueBasicGroup = new TorqueBasicGroup();
        try {
            torqueBasicGroup.setLoading(true);
            if (criteria == null) {
                torqueBasicGroup.setEntityId(this.getEntityId(resultSet, offset + 1));
                torqueBasicGroup.setEntityName(this.getEntityName(resultSet, offset + 2));
            } else {
                if (this.useMappingStrategy) {
                    this.initStrategy();
                }
                int totalOffset = offset + 1;
                UniqueColumnList selectColumns = criteria.getSelectColumns();
                List columnsWithoutOffset = selectColumns.subList(offset, selectColumns.size());
                HashSet<String> columnsMapped = new HashSet<String>();
                for (Column column : columnsWithoutOffset) {
                    int nextOffset = totalOffset;
                    if (!columnsMapped.contains(GROUP_ID_EXPRESSION) && GROUP_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEntityId(this.getEntityId((ResultSet)res, nextOffset)));
                        } else {
                            torqueBasicGroup.setEntityId(this.getEntityId(resultSet, totalOffset));
                        }
                        columnsMapped.add(GROUP_ID_EXPRESSION);
                    } else if (!columnsMapped.contains(GROUP_NAME_EXPRESSION) && GROUP_NAME_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEntityName(this.getEntityName((ResultSet)res, nextOffset)));
                        } else {
                            torqueBasicGroup.setEntityName(this.getEntityName(resultSet, totalOffset));
                        }
                        columnsMapped.add(GROUP_NAME_EXPRESSION);
                    }
                    ++totalOffset;
                }
                if (columnsMapped.isEmpty()) {
                    log.debug((Object)"no columns to map found in criteria, returning null");
                    Iterator iterator = null;
                    return iterator;
                }
                if (this.useMappingStrategy) {
                    this.strategy.finish(2, true);
                    this.strategy.execute(resultSet, (Object)torqueBasicGroup);
                }
            }
            torqueBasicGroup.setNew(false);
            torqueBasicGroup.setModified(false);
        }
        finally {
            torqueBasicGroup.setLoading(false);
        }
        return torqueBasicGroup;
    }

    protected Integer getEntityId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getEntityName(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

