/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.torque.om.BaseTorqueBasicUserPeer;
import org.apache.fulcrum.security.torque.om.TorqueBasicUser;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.MappingStrategy;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.UniqueColumnList;

public class BaseTorqueBasicUserRecordMapper
implements RecordMapper<TorqueBasicUser> {
    private static final long serialVersionUID = 1735909173139L;
    private static Log log = LogFactory.getLog(BaseTorqueBasicUserRecordMapper.class);
    private static final String USER_ID_EXPRESSION = BaseTorqueBasicUserPeer.USER_ID.getSqlExpression();
    private static final String LOGIN_NAME_EXPRESSION = BaseTorqueBasicUserPeer.LOGIN_NAME.getSqlExpression();
    private static final String PASSWORD_VALUE_EXPRESSION = BaseTorqueBasicUserPeer.PASSWORD_VALUE.getSqlExpression();
    private boolean useMappingStrategy = true;
    private MappingStrategy<TorqueBasicUser> strategy;

    public void initStrategy() {
        this.strategy = new MappingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorqueBasicUser processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        TorqueBasicUser torqueBasicUser = new TorqueBasicUser();
        try {
            torqueBasicUser.setLoading(true);
            if (criteria == null) {
                torqueBasicUser.setEntityId(this.getEntityId(resultSet, offset + 1));
                torqueBasicUser.setEntityName(this.getEntityName(resultSet, offset + 2));
                torqueBasicUser.setPassword(this.getPassword(resultSet, offset + 3));
            } else {
                if (this.useMappingStrategy) {
                    this.initStrategy();
                }
                int totalOffset = offset + 1;
                UniqueColumnList selectColumns = criteria.getSelectColumns();
                List columnsWithoutOffset = selectColumns.subList(offset, selectColumns.size());
                HashSet<String> columnsMapped = new HashSet<String>();
                for (Column column : columnsWithoutOffset) {
                    int nextOffset = totalOffset;
                    if (!columnsMapped.contains(USER_ID_EXPRESSION) && USER_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEntityId(this.getEntityId((ResultSet)res, nextOffset)));
                        } else {
                            torqueBasicUser.setEntityId(this.getEntityId(resultSet, totalOffset));
                        }
                        columnsMapped.add(USER_ID_EXPRESSION);
                    } else if (!columnsMapped.contains(LOGIN_NAME_EXPRESSION) && LOGIN_NAME_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEntityName(this.getEntityName((ResultSet)res, nextOffset)));
                        } else {
                            torqueBasicUser.setEntityName(this.getEntityName(resultSet, totalOffset));
                        }
                        columnsMapped.add(LOGIN_NAME_EXPRESSION);
                    } else if (!columnsMapped.contains(PASSWORD_VALUE_EXPRESSION) && PASSWORD_VALUE_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setPassword(this.getPassword((ResultSet)res, nextOffset)));
                        } else {
                            torqueBasicUser.setPassword(this.getPassword(resultSet, totalOffset));
                        }
                        columnsMapped.add(PASSWORD_VALUE_EXPRESSION);
                    }
                    ++totalOffset;
                }
                if (columnsMapped.isEmpty()) {
                    log.debug((Object)"no columns to map found in criteria, returning null");
                    Iterator iterator = null;
                    return iterator;
                }
                if (this.useMappingStrategy) {
                    this.strategy.finish(3, true);
                    this.strategy.execute(resultSet, (Object)torqueBasicUser);
                }
            }
            torqueBasicUser.setNew(false);
            torqueBasicUser.setModified(false);
        }
        finally {
            torqueBasicUser.setLoading(false);
        }
        return torqueBasicUser;
    }

    protected Integer getEntityId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getEntityName(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getPassword(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

