/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.entity.TurbineRole;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer;
import org.apache.fulcrum.security.torque.om.TorqueTurbineRolePermission;
import org.apache.fulcrum.security.torque.om.TorqueTurbineRolePermissionPeer;
import org.apache.fulcrum.security.torque.om.TorqueTurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TorqueTurbineUserGroupRolePeer;
import org.apache.fulcrum.security.torque.security.turbine.TorqueAbstractTurbineTurbineSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class FulcrumAbstractTurbineRole
extends TorqueAbstractTurbineTurbineSecurityEntity
implements TurbineRole {
    private static final long serialVersionUID = -1782236723198646728L;
    private Set<Permission> permissionSet = null;

    protected List<TorqueTurbineRolePermission> getTorqueTurbineRolePermissionsJoinTorqueTurbinePermission(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueTurbineRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
        return TorqueTurbineRolePermissionPeer.doSelectJoinTorqueTurbinePermission(criteria, con);
    }

    protected List<TorqueTurbineUserGroupRole> getTorqueTurbineUserGroupRolesJoinTorqueTurbineGroup(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueTurbineUserGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
        return TorqueTurbineUserGroupRolePeer.doSelectJoinTorqueTurbineGroup(criteria, con);
    }

    public void addPermission(Permission permission) {
        this.getPermissions().add((SecurityEntity)permission);
    }

    public PermissionSet getPermissions() {
        if (this.permissionSet == null) {
            this.permissionSet = new PermissionSet();
        } else if (!(this.permissionSet instanceof PermissionSet)) {
            this.permissionSet = new PermissionSet(this.permissionSet);
        }
        return (PermissionSet)this.permissionSet;
    }

    public <T extends Permission> Set<T> getPermissionsAsSet() {
        return this.permissionSet;
    }

    public void removePermission(Permission permission) {
        this.getPermissions().remove((Object)permission);
    }

    public void setPermissions(PermissionSet permissionSet) {
        this.permissionSet = permissionSet != null ? permissionSet : new PermissionSet();
    }

    public <T extends Permission> void setPermissionsAsSet(Set<T> permissions) {
        this.setPermissions(new PermissionSet(permissions));
    }

    public String getDatabaseName() {
        return TorqueTurbineRolePeer.DATABASE_NAME;
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        this.permissionSet = new PermissionSet();
        try {
            List<TorqueTurbineRolePermission> rolepermissions = this.getTorqueTurbineRolePermissionsJoinTorqueTurbinePermission(new Criteria(), con);
            for (TorqueTurbineRolePermission ttrp : rolepermissions) {
                this.permissionSet.add((Permission)ttrp.getTorqueTurbinePermission());
            }
            if (!lazy.booleanValue()) {
                HashSet<TurbineUserGroupRole> userGroupRoleSet = new HashSet<TurbineUserGroupRole>();
                List<TorqueTurbineUserGroupRole> ugrs = this.getTorqueTurbineUserGroupRolesJoinTorqueTurbineGroup(new Criteria(), con);
                for (TorqueTurbineUserGroupRole ttugr : ugrs) {
                    TurbineUserGroupRole ugr = new TurbineUserGroupRole();
                    ugr.setRole((Role)this);
                    ugr.setGroup((Group)ttugr.getTorqueTurbineGroup());
                    ugr.setUser((User)ttugr.getTorqueTurbineUser(con));
                    userGroupRoleSet.add(ugr);
                }
                this.setUserGroupRoleSet(userGroupRoleSet);
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public <T extends TurbineUserGroupRole> Set<T> getUserGroupRoleSet() throws DataBackendException {
        if (super.getUserGroupRoleSet() == null || super.getUserGroupRoleSet().isEmpty()) {
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                this.retrieveAttachedObjects((Connection)con, false);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("Error retrieving group information", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
        }
        return super.getUserGroupRoleSet();
    }

    @Override
    public void update(Connection con) throws TorqueException {
        if (this.permissionSet != null) {
            Criteria criteria = new Criteria();
            criteria.where((Object)TorqueTurbineRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
            TorqueTurbineRolePermissionPeer.doDelete(criteria, con);
            for (Permission p : this.permissionSet) {
                TorqueTurbineRolePermission rp = new TorqueTurbineRolePermission();
                rp.setPermissionId((Integer)p.getId());
                rp.setRoleId(this.getEntityId());
                rp.save(con);
            }
        }
    }

    @Override
    public void delete() throws TorqueException {
        TorqueTurbineRolePeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

