/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.memory.MemoryHelper;
import org.apache.fulcrum.security.spi.AbstractUserManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;

public class MemoryUserManagerImpl
extends AbstractUserManager {
    private static List<User> users = new ArrayList<User>();

    public MemoryUserManagerImpl() {
        users.clear();
    }

    public boolean checkExists(String userName) throws DataBackendException {
        return MemoryHelper.checkExists(users, userName);
    }

    public UserSet getAllUsers() throws DataBackendException {
        return new UserSet(users);
    }

    public <T extends User> UserSet<T> retrieveUserList(Object criteria) throws DataBackendException {
        List filteredusers = users.stream().filter(x -> x.getName().toLowerCase().contains(criteria.toString().toLowerCase())).collect(Collectors.toList());
        return new UserSet(filteredusers);
    }

    public void removeUser(User user) throws DataBackendException, UnknownEntityException {
        users.remove(user);
    }

    protected <T extends User> T persistNewUser(T user) throws DataBackendException {
        users.remove(user);
        user.setId((Object)MemoryHelper.getUniqueId());
        users.add(user);
        return user;
    }

    public void saveUser(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        userExists = this.checkExists(user);
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + String.valueOf(user) + "'");
        }
        users.remove(user);
        users.add(user);
    }
}

