/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.memory.turbine;

import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.AbstractTurbineModelManager;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineGroup;
import org.apache.fulcrum.security.model.turbine.entity.TurbinePermission;
import org.apache.fulcrum.security.model.turbine.entity.TurbineRole;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class MemoryTurbineModelManagerImpl
extends AbstractTurbineModelManager
implements TurbineModelManager {
    public synchronized void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        boolean permissionExists = false;
        try {
            roleExists = this.getRoleManager().checkExists(role);
            permissionExists = this.getPermissionManager().checkExists(permission);
            if (roleExists && permissionExists) {
                ((TurbineRole)role).addPermission(permission);
                ((TurbinePermission)permission).addRole(role);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", (Throwable)e);
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    public synchronized void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        boolean permissionExists = false;
        try {
            roleExists = this.getRoleManager().checkExists(role);
            permissionExists = this.getPermissionManager().checkExists(permission);
            if (roleExists && permissionExists) {
                ((TurbineRole)role).removePermission(permission);
                ((TurbinePermission)permission).removeRole(role);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("revoke(Role,Permission) failed", (Throwable)e);
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    public void grant(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        boolean userExists = false;
        boolean groupExists = false;
        try {
            roleExists = this.getRoleManager().checkExists(role);
            userExists = this.getUserManager().checkExists(user);
            groupExists = this.getGroupManager().checkExists(group);
            if (roleExists && groupExists && userExists) {
                TurbineUserGroupRole ugr = new TurbineUserGroupRole();
                ugr.setGroup(group);
                ugr.setRole(role);
                ugr.setUser(user);
                ((TurbineUser)user).addUserGroupRole(ugr);
                ((TurbineGroup)group).addUserGroupRole(ugr);
                ((TurbineRole)role).addUserGroupRole(ugr);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", (Throwable)e);
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public void revoke(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        boolean userExists = false;
        boolean groupExists = false;
        try {
            roleExists = this.getRoleManager().checkExists(role);
            userExists = this.getUserManager().checkExists(user);
            groupExists = this.getGroupManager().checkExists(group);
            if (roleExists && groupExists && userExists) {
                boolean ugrFound = false;
                for (TurbineUserGroupRole ugr : ((TurbineUser)user).getUserGroupRoleSet()) {
                    if (!ugr.getUser().equals((Object)user) || !ugr.getGroup().equals((Object)group) || !ugr.getRole().equals((Object)role)) continue;
                    ugrFound = true;
                    ((TurbineUser)user).removeUserGroupRole(ugr);
                    ((TurbineGroup)group).removeUserGroupRole(ugr);
                    ((TurbineRole)role).removeUserGroupRole(ugr);
                    break;
                }
                if (!ugrFound) {
                    throw new UnknownEntityException("Could not find User/Group/Role");
                }
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", (Throwable)e);
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public void replace(User user, Role oldRole, Role newRole) throws DataBackendException, UnknownEntityException {
        Group group = this.getGlobalGroup();
        this.revoke(user, group, oldRole);
        this.grant(user, group, newRole);
    }
}

