package org.apache.fulcrum.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.map.TableMap;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;



/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Fri Jan 03 13:59:32 CET 2025]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TorqueTurbineUserPeer
 */

@SuppressWarnings("unused")
public abstract class BaseTorqueTurbineUserPeerImpl
    extends org.apache.torque.util.AbstractPeerImpl<TorqueTurbineUser>
{
    /** Serial version */
    private static final long serialVersionUID = 1735909172817L;



    /**
     * Constructor.
     * The recordMapper, tableMap and databaseName fields are correctly
     * initialized.
     */
    public BaseTorqueTurbineUserPeerImpl()
    {
        this(new TorqueTurbineUserRecordMapper(),
            TorqueTurbineUserPeer.TABLE,
            TorqueTurbineUserPeer.DATABASE_NAME);
    }

    /**
     * Constructor providing the objects to be injected as parameters.
     *
     * @param recordMapper a record mapper to map JDBC result sets to objects
     * @param tableMap the default table map
     * @param databaseName the name of the database
     */
    public BaseTorqueTurbineUserPeerImpl(
            RecordMapper<TorqueTurbineUser> recordMapper, 
            TableMap tableMap,
            String databaseName)
    {
        super(recordMapper, tableMap, databaseName);
    }


    /**
     * Returns a new instance of the Data object class
     */
    public TorqueTurbineUser getDbObjectInstance()
    {
        return new TorqueTurbineUser();
    }


    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @param con the connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doUpdate(ColumnValues columnValues, Connection con)
        throws TorqueException
    {
        Criteria selectCriteria = new Criteria(getDatabaseName());
        correctBooleans(columnValues);

        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueTurbineUserPeer.USER_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueTurbineUserPeer.USER_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueTurbineUserPeer.USER_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueTurbineUserPeer.USER_ID,
                        pkValue.getSqlExpression());
            }
        }


        int rowCount = doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     *
     * @param obj the data object to delete in the database, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueTurbineUser obj) throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     * This method is to be used during a transaction, otherwise use the
     * doDelete(TorqueTurbineUser) method.
     *
     * @param obj the data object to delete in the database, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueTurbineUser obj, Connection con)
        throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     *
     * @param objects the data object to delete in the database, not null,
     *        may not contain null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(Collection<TorqueTurbineUser> objects)
            throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects));
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param objects the data objects to delete in the database, not null,
     *        may not contain null.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(
            Collection<TorqueTurbineUser> objects,
            Connection con)
        throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects), con);
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /** 
     * Build a Criteria object which selects all objects which have a given
     * primary key.
     *
     * @param pk the primary key value to build the criteria from, not null.
     */
    public Criteria buildCriteria(ObjectKey<?> pk)
    {
        Criteria criteria = new Criteria();
        criteria.and(TorqueTurbineUserPeer.USER_ID, pk);
        return criteria;
     }

    /** 
     * Build a Criteria object which selects all objects which primary keys
     * are contained in the passed collection.
     *
     * @param pks the primary key values to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildCriteria(Collection<ObjectKey<?>> pks)
    {
        Criteria criteria = new Criteria();
        criteria.andIn(TorqueTurbineUserPeer.USER_ID, pks);
        return criteria;
     }


    /** 
     * Build a Criteria object which selects all passed objects using their
     * primary key. Objects which do not yet have a primary key are ignored.
     *
     * @param objects the objects to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildPkCriteria(
            Collection<TorqueTurbineUser> objects)
    {
        return buildCriteria(objects.stream()
                .map(object -> object.getPrimaryKey())
                .collect(Collectors.toList()));
    }

    /** 
     * Build a Criteria object from the data object for this peer.
     * The primary key columns are only added if the object is not new.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildCriteria(TorqueTurbineUser obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        if (!obj.isNew())
        {
            criteria.and(TorqueTurbineUserPeer.USER_ID, obj.getEntityId());
        }
        criteria.and(TorqueTurbineUserPeer.LOGIN_NAME, obj.getEntityName());
        criteria.and(TorqueTurbineUserPeer.PASSWORD_VALUE, obj.getPassword());
        criteria.and(TorqueTurbineUserPeer.FIRST_NAME, obj.getFirstName());
        criteria.and(TorqueTurbineUserPeer.LAST_NAME, obj.getLastName());
        criteria.and(TorqueTurbineUserPeer.EMAIL, obj.getEmail());
        criteria.and(TorqueTurbineUserPeer.OBJECTDATA, obj.getObjectdata());
        return criteria;
    }

    /** 
     * Build a Criteria object from the data object for this peer,
     * skipping all binary columns.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildSelectCriteria(TorqueTurbineUser obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        if (!obj.isNew())
        {
            criteria.and(TorqueTurbineUserPeer.USER_ID, obj.getEntityId());
        }
        criteria.and(TorqueTurbineUserPeer.LOGIN_NAME, obj.getEntityName());
        criteria.and(TorqueTurbineUserPeer.PASSWORD_VALUE, obj.getPassword());
        criteria.and(TorqueTurbineUserPeer.FIRST_NAME, obj.getFirstName());
        criteria.and(TorqueTurbineUserPeer.LAST_NAME, obj.getLastName());
        criteria.and(TorqueTurbineUserPeer.EMAIL, obj.getEmail());
        return criteria;
    }

    /** 
     * Returns the contents of the object as ColumnValues object.
     * Primary key columns which are generated on insertion are not
     * added to the returned object if they still have their initial
     * value. Also, columns which have the useDatabaseDefaultValue
     * flag set to true are also not added to the returned object
     * if they still have their initial value.
     *
     * @throws TorqueException if the table map cannot be retrieved
     *         (should not happen).
     */
    public ColumnValues buildColumnValues(TorqueTurbineUser torqueTurbineUser)
            throws TorqueException
    {
        ColumnValues columnValues = new ColumnValues();
        if (!torqueTurbineUser.isNew() 
            || torqueTurbineUser.getEntityId() != null)
        {
            columnValues.put(
                    TorqueTurbineUserPeer.USER_ID,
                    new JdbcTypedValue(
                        torqueTurbineUser.getEntityId(),
                        4));
        }
        columnValues.put(
                TorqueTurbineUserPeer.LOGIN_NAME,
                new JdbcTypedValue(
                    torqueTurbineUser.getEntityName(),
                    12));
        columnValues.put(
                TorqueTurbineUserPeer.PASSWORD_VALUE,
                new JdbcTypedValue(
                    torqueTurbineUser.getPassword(),
                    12));
        columnValues.put(
                TorqueTurbineUserPeer.FIRST_NAME,
                new JdbcTypedValue(
                    torqueTurbineUser.getFirstName(),
                    12));
        columnValues.put(
                TorqueTurbineUserPeer.LAST_NAME,
                new JdbcTypedValue(
                    torqueTurbineUser.getLastName(),
                    12));
        columnValues.put(
                TorqueTurbineUserPeer.EMAIL,
                new JdbcTypedValue(
                    torqueTurbineUser.getEmail(),
                    12));
        columnValues.put(
                TorqueTurbineUserPeer.OBJECTDATA,
                new JdbcTypedValue(
                    torqueTurbineUser.getObjectdata(),
                    -3));
        return columnValues;
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueTurbineUser retrieveByPK(Integer pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return retrieveByPK(SimpleKey.keyFor(pk));
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueTurbineUser retrieveByPK(Integer pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return retrieveByPK(SimpleKey.keyFor(pk), con);
    }
    
    
    

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueTurbineUser retrieveByPK(ObjectKey<?> pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueTurbineUser result = retrieveByPK(pk, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueTurbineUser retrieveByPK(ObjectKey<?> pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        Criteria criteria = buildCriteria(pk);
        TorqueTurbineUser v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }


    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUser> retrieveByTypedPKs(Collection<Integer> pks)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineUser> result = retrieveByTypedPKs(pks, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUser> retrieveByTypedPKs(
                Collection<Integer> pks,
                Connection dbcon)
            throws TorqueException
    {
        if (pks == null || pks.size() == 0)
        {
            return new ArrayList<TorqueTurbineUser>();
        }
        List<ObjectKey<?>> objectKeyList = new ArrayList<ObjectKey<?>>();
        for (Integer pk : pks)
        {
            objectKeyList.add(SimpleKey.keyFor(pk));
        }
        Criteria criteria = buildCriteria(objectKeyList);
        List<TorqueTurbineUser> result = doSelect(criteria, dbcon);
        return result;
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUser> retrieveByObjectKeys(Collection<ObjectKey<?>> pks)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineUser> result = retrieveByObjectKeys(pks, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUser> retrieveByObjectKeys(
                Collection<ObjectKey<?>> pks,
                Connection dbcon)
            throws TorqueException
    {
        if (pks == null || pks.size() == 0)
        {
            return new ArrayList<TorqueTurbineUser>();
        }
        Criteria criteria = buildCriteria(pks);
        List<TorqueTurbineUser> result = doSelect(criteria, dbcon);
        return result;
    }




    /** 
     * Saves the passed collection as linked objects.
     * This means the following is done:
     * <ul>
     *  <li>
     *    The current collection of objects which are linked to toLinkTo
     *    and which are also in the list toSave is read from the database
     *    into the list intersection.
     *  </li>
     *  <li>
     *    All objects in toSave which are not in intersection are inserted.
     *  </li>
     *  <li>
     *    All objects in intersection are updated with the 
     *    corresponding values in toSave and saved.
     *  </li>
     *  <li>
     *    All objects in the database which are linked to toLinkTo but are 
     *    not in toSave are deleted from the database.
     *  </li>
     * </ul>
     *
     * @param toLinkTo the object which collections should be set with the
     *        values in toSave.
     * @param toSave Contains the objects to save, not null, 
     *        may not contain null.
     *
     * @throws TorqueException if an error accessing the database occurs.
     * @throws NullPointerException if toSave is null or contains null elements.
     */
    public void setAndSaveTorqueTurbineUserGroupRoles(
            TorqueTurbineUser toLinkTo,
            Collection<TorqueTurbineUserGroupRole> toSave) 
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            setAndSaveTorqueTurbineUserGroupRoles(toLinkTo, toSave, connection);
            Transaction.commit(connection);
        }
    }

    /** 
     * Saves the passed collection as linked objects.
     * This means the following is done:
     * <ul>
     *  <li>
     *    The current collection of objects which are linked to toLinkTo
     *    and which are also in the list toSave is read from the database
     *    into the list intersection.
     *  </li>
     *  <li>
     *    All objects in toSave which are not in intersection are inserted.
     *  </li>
     *  <li>
     *    All objects in intersection are updated with the 
     *    corresponding values in toSave and saved.
     *  </li>
     *  <li>
     *    All objects in the database which are linked to toLinkTo but are 
     *    not in toSave are deleted from the database.
     *  </li>
     * </ul>
     *
     * @param toLinkTo the object which collections should be set with the
     *        values in toSave.
     * @param toSave Contains the objects to save, not null, 
     *        may not contain null.
     * @param connection the database connection to use.
     *
     * @throws TorqueException if an error accessing the database occurs.
     * @throws NullPointerException if toSave is null or contains null elements.
     */
    public void setAndSaveTorqueTurbineUserGroupRoles(
            TorqueTurbineUser toLinkTo,
            Collection<TorqueTurbineUserGroupRole> toSave,
            Connection connection) 
        throws TorqueException
    {
        // make sure the collection cache in toLinkTo represents the current
        // database state
        toLinkTo.resetTorqueTurbineUserGroupRole();
        toLinkTo.getTorqueTurbineUserGroupRoles(connection);
        ObjectKey<?> localKey = toLinkTo.getPrimaryKey();

        Criteria criteria = new Criteria();
        Criterion onlyReferencingCriterion = new Criterion(
                TorqueTurbineUserGroupRolePeer.USER_ID, 
                localKey);
        criteria.where(onlyReferencingCriterion);
        Set<ObjectKey<?>> toSaveKeys = new HashSet<ObjectKey<?>>();
        for (TorqueTurbineUserGroupRole toSaveElement : toSave)
        {
            ObjectKey<?> toSaveKey = toSaveElement.getPrimaryKey();
            if (toSaveKey.getValue() != null)
            {
                toSaveKeys.add(toSaveKey);
            }
        }
        
        // calculate intersection between objects in the database
        // and objects in the list
        List<TorqueTurbineUserGroupRole> intersection;
        if (toSaveKeys.isEmpty())
        {
            intersection = new ArrayList<TorqueTurbineUserGroupRole>();
        }
        else
        {
            Criterion toSaveKeyCriterion = null;
            for (ObjectKey<?> toSaveKey : toSaveKeys)
            {
                SimpleKey<?>[] toSavePrimaryKeys = (SimpleKey[]) toSaveKey.getValue();
                 Criterion p0 = new Criterion(
                        TorqueTurbineUserGroupRolePeer.USER_ID,
                        toSavePrimaryKeys[0]);
                 Criterion p1 = new Criterion(
                        TorqueTurbineUserGroupRolePeer.GROUP_ID,
                        toSavePrimaryKeys[1]);
                p0.and(p1);
                 Criterion p2 = new Criterion(
                        TorqueTurbineUserGroupRolePeer.ROLE_ID,
                        toSavePrimaryKeys[2]);
                p1.and(p2);
                if (toSaveKeyCriterion == null)
                {
                    toSaveKeyCriterion = p0;
                }
                else
                {
                    toSaveKeyCriterion.or(p0);
                }
            }
            criteria.and(toSaveKeyCriterion);
            intersection = TorqueTurbineUserGroupRolePeer.doSelect(
                    criteria,
                    connection);
        }
        if (toLinkTo.isTorqueTurbineUserGroupRolesInitialized())
        {
            toLinkTo.getTorqueTurbineUserGroupRoles().clear();
        }
        else
        {
           toLinkTo.initTorqueTurbineUserGroupRoles();
        }
        for (TorqueTurbineUserGroupRole toSaveElement : toSave)
        {
            int listIndex = intersection.indexOf(toSaveElement);
            if (listIndex == -1)
            {
                toLinkTo.addTorqueTurbineUserGroupRole(toSaveElement);
                toSaveElement.save(connection);
            }
            else
            {
                toLinkTo.addTorqueTurbineUserGroupRole(toSaveElement);
                toSaveElement.setNew(false);
                if (!toSaveElement.valueEquals(intersection.get(listIndex)))
                {
                    //force saving if content differs
                    toSaveElement.setModified(true);
                }
                toSaveElement.save(connection);
            }
            toSaveKeys.add(toSaveElement.getPrimaryKey());
        }
        
        // delete elements not in intersection
        Criteria deleteCriteria = new Criteria();
        deleteCriteria.where(onlyReferencingCriterion);
        if (!toSaveKeys.isEmpty())
        {
            Criterion toSaveKeyCriterion = null;
            for (ObjectKey<?> toSaveKey : toSaveKeys)
            {
                SimpleKey<?>[] toSavePrimaryKeys = (SimpleKey[]) toSaveKey.getValue();
                  Criterion p0 = new Criterion(
                         TorqueTurbineUserGroupRolePeer.USER_ID,
                         toSavePrimaryKeys[0],
                         Criteria.NOT_EQUAL);
                  Criterion p1 = new Criterion(
                         TorqueTurbineUserGroupRolePeer.GROUP_ID,
                         toSavePrimaryKeys[1],
                         Criteria.NOT_EQUAL);
                p0.or(p1);
                  Criterion p2 = new Criterion(
                         TorqueTurbineUserGroupRolePeer.ROLE_ID,
                         toSavePrimaryKeys[2],
                         Criteria.NOT_EQUAL);
                p1.or(p2);
                if (toSaveKeyCriterion == null)
                {
                    toSaveKeyCriterion = p0;
                }
                else
                {
                    toSaveKeyCriterion.and(p0);
                }
            }
            deleteCriteria.and(toSaveKeyCriterion);
        }
        TorqueTurbineUserGroupRolePeer.doDelete(deleteCriteria, connection);
    }


}
