/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque;

import java.sql.Connection;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.spi.AbstractRoleManager;
import org.apache.fulcrum.security.torque.LazyLoadable;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class TorqueAbstractRoleManager
extends AbstractRoleManager
implements LazyLoadable {
    private static final long serialVersionUID = 4258137881250800204L;
    private static final String LAZY_LOADING = "lazy";
    protected Boolean lazyLoading = false;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.lazyLoading = conf.getAttributeAsBoolean(LAZY_LOADING, false);
        this.getLogger().debug("setting lazyLoading: " + this.lazyLoading);
    }

    protected abstract <T extends Role> List<T> doSelectAllRoles(Connection var1) throws TorqueException;

    protected abstract <T extends Role> T doSelectByName(String var1, Connection var2) throws NoRowsException, TooManyRowsException, TorqueException;

    protected abstract <T extends Role> T doSelectById(Integer var1, Connection var2) throws NoRowsException, TooManyRowsException, TorqueException;

    public synchronized void renameRole(Role role, String name) throws DataBackendException, UnknownEntityException {
        if (this.checkExists(role)) {
            role.setName(name);
            try {
                TorqueAbstractSecurityEntity r = (TorqueAbstractSecurityEntity)role;
                r.setNew(false);
                r.save();
            }
            catch (Exception e) {
                throw new DataBackendException("Renaming Role '" + role.getName() + "' failed", (Throwable)e);
            }
        } else {
            throw new UnknownEntityException("Unknown Role '" + role.getName() + "'");
        }
    }

    protected synchronized <T extends Role> T persistNewRole(T role) throws DataBackendException {
        try {
            ((TorqueAbstractSecurityEntity)role).save();
        }
        catch (Exception e) {
            throw new DataBackendException("Adding Role '" + role.getName() + "' failed", (Throwable)e);
        }
        return role;
    }

    public synchronized void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        if (this.checkExists(role)) {
            try {
                ((TorqueAbstractSecurityEntity)role).delete();
            }
            catch (TorqueException e) {
                throw new DataBackendException("Removing Role '" + role.getName() + "' failed", (Throwable)e);
            }
        } else {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public boolean checkExists(String roleName) throws DataBackendException {
        boolean exists = false;
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            this.doSelectByName(roleName, (Connection)con);
            Transaction.commit((Connection)con);
            con = null;
            exists = true;
        }
        catch (NoRowsException e) {
            exists = false;
        }
        catch (TooManyRowsException e) {
            throw new DataBackendException("Multiple roles with same name '" + roleName + "'");
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving role information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return exists;
    }

    public RoleSet getAllRoles() throws DataBackendException {
        RoleSet roleSet = new RoleSet();
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            List roles = this.doSelectAllRoles((Connection)con);
            for (Role role : roles) {
                ((TorqueAbstractSecurityEntity)role).retrieveAttachedObjects((Connection)con, this.getLazyLoading());
                roleSet.add((SecurityEntity)role);
            }
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving role information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return roleSet;
    }

    public <T extends Role> T getRoleById(Object id) throws DataBackendException, UnknownEntityException {
        T role;
        if (id != null && id instanceof Integer) {
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                role = this.doSelectById((Integer)id, (Connection)con);
                ((TorqueAbstractSecurityEntity)role).retrieveAttachedObjects((Connection)con, this.getLazyLoading());
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (NoRowsException e) {
                throw new UnknownEntityException("Role with id '" + String.valueOf(id) + "' does not exist.", (Throwable)e);
            }
            catch (TorqueException e) {
                throw new DataBackendException("Error retrieving role information", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
        } else {
            throw new UnknownEntityException("Invalid role id '" + String.valueOf(id) + "'");
        }
        return role;
    }

    public <T extends Role> T getRoleByName(String name) throws DataBackendException, UnknownEntityException {
        T role = null;
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            role = this.doSelectByName(name, (Connection)con);
            ((TorqueAbstractSecurityEntity)role).retrieveAttachedObjects((Connection)con, this.getLazyLoading());
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (NoRowsException e) {
            throw new UnknownEntityException("Could not find role " + name);
        }
        catch (TooManyRowsException e) {
            throw new DataBackendException("Multiple Roles with same name '" + name + "'");
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving role information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return role;
    }

    @Override
    public Boolean getLazyLoading() {
        return this.lazyLoading;
    }

    @Override
    public void setLazyLoading(Boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }
}

