/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.spring;

import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.CommonsLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AvalonContainerBean
implements BeanNameAware,
BeanFactoryAware,
ServiceManager,
Initializable,
Disposable {
    private ServiceManager serviceManager;
    private Logger logger;
    private String beanName;
    private BeanFactory beanFactory;
    private Map defaultContext;

    public abstract void initialize() throws Exception;

    public abstract void dispose();

    public Object lookup(String s) throws ServiceException {
        return this.getServiceManager().lookup(s);
    }

    public boolean hasService(String s) {
        return this.getServiceManager().hasService(s);
    }

    public void release(Object o) {
        this.getServiceManager().release(o);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Map getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(Map defaultContext) {
        this.defaultContext = defaultContext;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected Logger createLogger() {
        Log log = LogFactory.getLog((String)this.getBeanName());
        return new CommonsLogger(log, this.getBeanName());
    }

    protected ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    protected void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }
}

