/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class GetFeatureAction
extends AbstractRutaAction {
    private IStringExpression featureStringExpression;
    private String variable;

    public GetFeatureAction(IStringExpression f, String variable) {
        this.featureStringExpression = f;
        this.variable = variable;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        RutaBlock parent = element.getParent();
        AnnotationFS annotation = context.getAnnotation();
        if (annotation == null) {
            return;
        }
        String stringValue = this.featureStringExpression.getStringValue(context, stream);
        RutaEnvironment environment = parent.getEnvironment();
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotationsOfElement(element);
        for (AnnotationFS annotationFS : matchedAnnotations) {
            Object value;
            Feature featureByBaseName = annotationFS.getType().getFeatureByBaseName(stringValue);
            if (featureByBaseName == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Can't access feature " + stringValue + ", because it's not defined in the matched type: " + annotationFS.getType().getName());
                continue;
            }
            TypeSystem typeSystem = stream.getCas().getTypeSystem();
            Type range = featureByBaseName.getRange();
            String featName = range.getName();
            if (environment.getVariableType(this.variable).equals(String.class) && typeSystem.subsumes(typeSystem.getType("uima.cas.String"), range)) {
                value = annotationFS.getStringValue(featureByBaseName);
                environment.setVariableValue(this.variable, value);
                continue;
            }
            if (Number.class.isAssignableFrom(environment.getVariableType(this.variable))) {
                value = 0;
                if (featName.equals("uima.cas.Integer")) {
                    value = annotationFS.getIntValue(featureByBaseName);
                } else if (featName.equals("uima.cas.Double")) {
                    value = annotationFS.getDoubleValue(featureByBaseName);
                } else if (featName.equals("uima.cas.Float")) {
                    value = Float.valueOf(annotationFS.getFloatValue(featureByBaseName));
                } else if (featName.equals("uima.cas.Byte")) {
                    value = annotationFS.getByteValue(featureByBaseName);
                } else if (featName.equals("uima.cas.Short")) {
                    value = annotationFS.getShortValue(featureByBaseName);
                } else if (featName.equals("uima.cas.Long")) {
                    value = annotationFS.getLongValue(featureByBaseName);
                }
                environment.setVariableValue(this.variable, value);
                continue;
            }
            if (environment.getVariableType(this.variable).equals(Boolean.class) && featName.equals("uima.cas.Boolean")) {
                value = annotationFS.getBooleanValue(featureByBaseName);
                environment.setVariableValue(this.variable, value);
                continue;
            }
            if (!environment.getVariableType(this.variable).equals(Type.class) || !typeSystem.subsumes(typeSystem.getType("uima.cas.String"), range)) continue;
            value = annotationFS.getStringValue(featureByBaseName);
            Type t = stream.getCas().getTypeSystem().getType((String)value);
            if (t == null) continue;
            environment.setVariableValue(this.variable, t);
        }
    }

    public IStringExpression getFeatureStringExpression() {
        return this.featureStringExpression;
    }

    public String getVariable() {
        return this.variable;
    }
}

