/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.compression;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Factory;
import org.apache.uniffle.common.compression.Codec;
import org.apache.uniffle.common.exception.RssException;

public class Lz4Codec
extends Codec {
    private LZ4Factory lz4Factory = LZ4Factory.fastestInstance();

    public static Lz4Codec getInstance() {
        return LazyHolder.INSTANCE;
    }

    @Override
    public void decompress(ByteBuffer src, int uncompressedLen, ByteBuffer dest, int destOffset) {
        this.lz4Factory.fastDecompressor().decompress(src, src.position(), dest, destOffset, uncompressedLen);
    }

    @Override
    public byte[] compress(byte[] src) {
        return this.lz4Factory.fastCompressor().compress(src);
    }

    @Override
    public int compress(ByteBuffer src, ByteBuffer dest) {
        try {
            int destOff = dest.position();
            this.lz4Factory.fastCompressor().compress(src.duplicate(), dest);
            return dest.position() - destOff;
        }
        catch (Exception e) {
            throw new RssException("Failed to compress by Lz4", e);
        }
    }

    @Override
    public int maxCompressedLength(int sourceLength) {
        return this.lz4Factory.fastCompressor().maxCompressedLength(sourceLength);
    }

    private static class LazyHolder {
        static final Lz4Codec INSTANCE = new Lz4Codec();

        private LazyHolder() {
        }
    }
}

