/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import java.util.Map;
import java.util.Set;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.common.storage.StorageInfo;
import org.apache.uniffle.guava.collect.Maps;
import org.apache.uniffle.proto.RssProtos;

public class ServerNode
implements Comparable<ServerNode> {
    private String id;
    private String ip;
    private int grpcPort;
    private long usedMemory;
    private long preAllocatedMemory;
    private long availableMemory;
    private int eventNumInFlush;
    private long timestamp;
    private Set<String> tags;
    private ServerStatus status;
    private Map<String, StorageInfo> storageInfo;
    private int nettyPort = -1;

    public ServerNode(String id, String ip, int port, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags) {
        this(id, ip, port, usedMemory, preAllocatedMemory, availableMemory, eventNumInFlush, tags, ServerStatus.ACTIVE, Maps.newHashMap());
    }

    public ServerNode(String id, String ip, int port, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags, ServerStatus status) {
        this(id, ip, port, usedMemory, preAllocatedMemory, availableMemory, eventNumInFlush, tags, status, Maps.newHashMap());
    }

    public ServerNode(String id, String ip, int port, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags, ServerStatus status, Map<String, StorageInfo> storageInfoMap) {
        this(id, ip, port, usedMemory, preAllocatedMemory, availableMemory, eventNumInFlush, tags, status, storageInfoMap, -1);
    }

    public ServerNode(String id, String ip, int grpcPort, long usedMemory, long preAllocatedMemory, long availableMemory, int eventNumInFlush, Set<String> tags, ServerStatus status, Map<String, StorageInfo> storageInfoMap, int nettyPort) {
        this.id = id;
        this.ip = ip;
        this.grpcPort = grpcPort;
        this.usedMemory = usedMemory;
        this.preAllocatedMemory = preAllocatedMemory;
        this.availableMemory = availableMemory;
        this.eventNumInFlush = eventNumInFlush;
        this.timestamp = System.currentTimeMillis();
        this.tags = tags;
        this.status = status;
        this.storageInfo = storageInfoMap;
        if (nettyPort > 0) {
            this.nettyPort = nettyPort;
        }
    }

    public RssProtos.ShuffleServerId convertToGrpcProto() {
        return RssProtos.ShuffleServerId.newBuilder().setId(this.id).setIp(this.ip).setPort(this.grpcPort).setNettyPort(this.nettyPort).build();
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public int getGrpcPort() {
        return this.grpcPort;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getPreAllocatedMemory() {
        return this.preAllocatedMemory;
    }

    public long getAvailableMemory() {
        return this.availableMemory;
    }

    public int getEventNumInFlush() {
        return this.eventNumInFlush;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public void setStatus(ServerStatus serverStatus) {
        this.status = serverStatus;
    }

    public Map<String, StorageInfo> getStorageInfo() {
        return this.storageInfo;
    }

    public String toString() {
        return "ServerNode with id[" + this.id + "], ip[" + this.ip + "], grpc port[" + this.grpcPort + "], netty port[" + this.nettyPort + "], usedMemory[" + this.usedMemory + "], preAllocatedMemory[" + this.preAllocatedMemory + "], availableMemory[" + this.availableMemory + "], eventNumInFlush[" + this.eventNumInFlush + "], timestamp[" + this.timestamp + "], tags" + this.tags.toString() + ", status[" + this.status + "], storages[num=" + this.storageInfo.size() + "]";
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public int compareTo(ServerNode other) {
        if (this.availableMemory > other.getAvailableMemory()) {
            return -1;
        }
        if (this.availableMemory < other.getAvailableMemory()) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerNode) {
            return this.id.equals(((ServerNode)obj).getId());
        }
        return false;
    }

    public long getTotalMemory() {
        return this.availableMemory + this.usedMemory;
    }

    public int getNettyPort() {
        return this.nettyPort;
    }
}

