/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.storage.api.FileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileReader
implements FileReader,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileReader.class);
    private String path;
    private DataInputStream dataInputStream;

    public LocalFileReader(String path) throws Exception {
        this.path = path;
        this.dataInputStream = new DataInputStream(new FileInputStream(path));
    }

    @Override
    public byte[] read(long offset, int length) {
        try {
            long targetSkip = offset;
            while (targetSkip > 0L) {
                long realSkip = this.dataInputStream.skip(targetSkip);
                if (realSkip == -1L) {
                    throw new RssException("Unexpected EOF when skip bytes");
                }
                if ((targetSkip -= realSkip) <= 0L) continue;
                LOG.warn("Got unexpected skip for path:" + this.path + " with offset[" + offset + "], length[" + length + "], remain[" + targetSkip + "]");
            }
            byte[] buf = new byte[length];
            this.dataInputStream.readFully(buf);
            return buf;
        }
        catch (Exception e) {
            LOG.warn("Can't read data for path:" + this.path + " with offset[" + offset + "], length[" + length + "]", (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    public byte[] read() {
        try {
            return IOUtils.toByteArray((InputStream)this.dataInputStream);
        }
        catch (IOException e) {
            LOG.error("Fail to read all data from {}", (Object)this.path, (Object)e);
            return new byte[0];
        }
    }

    @Override
    public ByteBuffer readAsByteBuffer(long offset, int length) {
        throw new UnsupportedOperationException("Local file reader don't support off heap read now");
    }

    @Override
    public ByteBuffer readAsByteBuffer() {
        throw new UnsupportedOperationException("Local file reader don't support off heap read now");
    }

    @Override
    public synchronized void close() {
        if (this.dataInputStream != null) {
            try {
                this.dataInputStream.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error happen when close " + this.path, (Throwable)ioe);
            }
        }
    }
}

