/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage;

import java.util.Set;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.storage.StorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageManagerFallbackStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStorageManagerFallbackStrategy.class);
    protected ShuffleServerConf conf;

    public AbstractStorageManagerFallbackStrategy(ShuffleServerConf conf) {
        this.conf = conf;
    }

    public abstract StorageManager tryFallback(StorageManager var1, ShuffleDataFlushEvent var2, StorageManager ... var3);

    protected StorageManager findNextStorageManager(StorageManager current, Set<Class<? extends StorageManager>> excludeTypes, ShuffleDataFlushEvent event, StorageManager ... candidates) {
        int i;
        int nextIdx = -1;
        for (i = 0; i < candidates.length; ++i) {
            if (current != candidates[i]) continue;
            nextIdx = (i + 1) % candidates.length;
            break;
        }
        if (nextIdx == -1) {
            throw new RssException("Current StorageManager is not in candidates");
        }
        for (i = 0; i < candidates.length - 1; ++i) {
            StorageManager storageManager = candidates[(i + nextIdx) % candidates.length];
            if (excludeTypes != null && excludeTypes.contains(storageManager.getClass()) || !storageManager.canWrite(event)) continue;
            return storageManager;
        }
        LOG.warn("Find next storageManager failed, all candidates are not available.");
        return current;
    }
}

