/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.shuffle.RssShuffleHandle;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.RssSparkShuffleUtils;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleHandleInfo;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.reader.RssShuffleReader;
import org.apache.spark.shuffle.writer.AddBlockEvent;
import org.apache.spark.shuffle.writer.DataPusher;
import org.apache.spark.shuffle.writer.RssShuffleWriter;
import org.apache.spark.storage.BlockManagerId;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.client.util.ClientUtils;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.com.google.common.collect.Maps;
import org.apache.uniffle.com.google.common.collect.Sets;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleAssignmentsInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.common.rpc.GrpcServer;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.RetryUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.shuffle.manager.RssShuffleManagerBase;
import org.apache.uniffle.shuffle.manager.ShuffleManagerGrpcService;
import org.apache.uniffle.shuffle.manager.ShuffleManagerServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;

public class RssShuffleManager
extends RssShuffleManagerBase {
    private static final Logger LOG = LoggerFactory.getLogger(RssShuffleManager.class);
    private final long heartbeatInterval;
    private final long heartbeatTimeout;
    private ScheduledExecutorService heartBeatScheduledExecutorService;
    private SparkConf sparkConf;
    private String appId = "";
    private String clientType;
    private ShuffleWriteClient shuffleWriteClient;
    private Map<String, Set<Long>> taskToSuccessBlockIds = JavaUtils.newConcurrentMap();
    private Map<String, Set<Long>> taskToFailedBlockIds = JavaUtils.newConcurrentMap();
    private final int dataReplica;
    private final int dataReplicaWrite;
    private final int dataReplicaRead;
    private final boolean dataReplicaSkipEnabled;
    private final int dataTransferPoolSize;
    private final int dataCommitPoolSize;
    private Set<String> failedTaskIds = Sets.newConcurrentHashSet();
    private boolean heartbeatStarted = false;
    private boolean dynamicConfEnabled = false;
    private final String user;
    private final String uuid;
    private DataPusher dataPusher;
    private final int maxConcurrencyPerPartitionToWrite;
    private final Map<Integer, Integer> shuffleIdToPartitionNum = Maps.newConcurrentMap();
    private final Map<Integer, Integer> shuffleIdToNumMapTasks = Maps.newConcurrentMap();
    private GrpcServer shuffleManagerServer;
    private ShuffleManagerGrpcService service;

    public RssShuffleManager(SparkConf sparkConf, boolean isDriver) {
        if (sparkConf.getBoolean("spark.sql.adaptive.enabled", false)) {
            throw new IllegalArgumentException("Spark2 doesn't support AQE, spark.sql.adaptive.enabled should be false.");
        }
        this.sparkConf = sparkConf;
        this.user = sparkConf.get("spark.rss.quota.user", "user");
        this.uuid = sparkConf.get("spark.rss.quota.uuid", Long.toString(System.currentTimeMillis()));
        this.dataReplica = (Integer)sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA);
        this.dataReplicaWrite = (Integer)sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA_WRITE);
        this.dataReplicaRead = (Integer)sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA_READ);
        this.dataTransferPoolSize = (Integer)sparkConf.get(RssSparkConfig.RSS_DATA_TRANSFER_POOL_SIZE);
        this.dataReplicaSkipEnabled = (Boolean)sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA_SKIP_ENABLED);
        this.maxConcurrencyPerPartitionToWrite = RssSparkConfig.toRssConf(sparkConf).get(RssClientConf.MAX_CONCURRENCY_PER_PARTITION_TO_WRITE);
        LOG.info("Check quorum config [" + this.dataReplica + ":" + this.dataReplicaWrite + ":" + this.dataReplicaRead + ":" + this.dataReplicaSkipEnabled + "]");
        RssUtils.checkQuorumSetting(this.dataReplica, this.dataReplicaWrite, this.dataReplicaRead);
        this.clientType = (String)sparkConf.get(RssSparkConfig.RSS_CLIENT_TYPE);
        this.heartbeatInterval = (Long)sparkConf.get(RssSparkConfig.RSS_HEARTBEAT_INTERVAL);
        this.heartbeatTimeout = sparkConf.getLong(RssSparkConfig.RSS_HEARTBEAT_TIMEOUT.key(), this.heartbeatInterval / 2L);
        this.dynamicConfEnabled = (Boolean)sparkConf.get(RssSparkConfig.RSS_DYNAMIC_CLIENT_CONF_ENABLED);
        int retryMax = (Integer)sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_MAX);
        long retryIntervalMax = (Long)sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_INTERVAL_MAX);
        int heartBeatThreadNum = (Integer)sparkConf.get(RssSparkConfig.RSS_CLIENT_HEARTBEAT_THREAD_NUM);
        this.dataCommitPoolSize = (Integer)sparkConf.get(RssSparkConfig.RSS_DATA_COMMIT_POOL_SIZE);
        int unregisterThreadPoolSize = (Integer)sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_THREAD_POOL_SIZE);
        int unregisterRequestTimeoutSec = (Integer)sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_REQUEST_TIMEOUT_SEC);
        RssConf rssConf = RssSparkConfig.toRssConf(sparkConf);
        this.shuffleWriteClient = ShuffleClientFactory.getInstance().createShuffleWriteClient(this.clientType, retryMax, retryIntervalMax, heartBeatThreadNum, this.dataReplica, this.dataReplicaWrite, this.dataReplicaRead, this.dataReplicaSkipEnabled, this.dataTransferPoolSize, this.dataCommitPoolSize, unregisterThreadPoolSize, unregisterRequestTimeoutSec, rssConf);
        this.registerCoordinator();
        if (isDriver && this.dynamicConfEnabled) {
            Map<String, String> clusterClientConf = this.shuffleWriteClient.fetchClientConf((Integer)sparkConf.get(RssSparkConfig.RSS_ACCESS_TIMEOUT_MS));
            RssSparkShuffleUtils.applyDynamicClientConf(sparkConf, clusterClientConf);
        }
        RssSparkShuffleUtils.validateRssClientConf(sparkConf);
        sparkConf.set("spark.shuffle.service.enabled", "false");
        LOG.info("Disable external shuffle service in RssShuffleManager.");
        sparkConf.set("spark.shuffle.reduceLocality.enabled", "false");
        LOG.info("Disable shuffle data locality in RssShuffleManager.");
        if (!sparkConf.getBoolean(RssSparkConfig.RSS_TEST_FLAG.key(), false)) {
            if (isDriver) {
                this.heartBeatScheduledExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor("rss-heartbeat");
                if (((Boolean)sparkConf.get(RssSparkConfig.RSS_RESUBMIT_STAGE)).booleanValue() && RssSparkShuffleUtils.isStageResubmitSupported()) {
                    LOG.info("stage resubmit is supported and enabled");
                    rssConf.set(RssBaseConf.RPC_SERVER_PORT, 0);
                    ShuffleManagerServerFactory factory = new ShuffleManagerServerFactory(this, rssConf);
                    this.service = factory.getService();
                    this.shuffleManagerServer = factory.getServer(this.service);
                    try {
                        this.shuffleManagerServer.start();
                        sparkConf.set(RssSparkConfig.RSS_SHUFFLE_MANAGER_GRPC_PORT, (Object)this.shuffleManagerServer.getPort());
                    }
                    catch (Exception e) {
                        LOG.error("Failed to start shuffle manager server", (Throwable)e);
                        throw new RssException(e);
                    }
                }
            }
            LOG.info("RSS data pusher is starting...");
            int poolSize = (Integer)sparkConf.get(RssSparkConfig.RSS_CLIENT_SEND_THREAD_POOL_SIZE);
            int keepAliveTime = (Integer)sparkConf.get(RssSparkConfig.RSS_CLIENT_SEND_THREAD_POOL_KEEPALIVE);
            this.dataPusher = new DataPusher(this.shuffleWriteClient, this.taskToSuccessBlockIds, this.taskToFailedBlockIds, this.failedTaskIds, poolSize, keepAliveTime);
        }
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, int numMaps, ShuffleDependency<K, V, C> dependency) {
        Map partitionToServers;
        if (!SparkEnv.get().serializer().supportsRelocationOfSerializedObjects()) {
            throw new IllegalArgumentException("Can't use serialized shuffle for shuffleId: " + shuffleId + ", because the serializer: " + SparkEnv.get().serializer().getClass().getName() + " does not support object relocation.");
        }
        if ("".equals(this.appId)) {
            this.appId = SparkEnv.get().conf().getAppId() + "_" + this.uuid;
            this.dataPusher.setRssAppId(this.appId);
            LOG.info("Generate application id used in rss: " + this.appId);
        }
        if (dependency.partitioner().numPartitions() == 0) {
            this.shuffleIdToPartitionNum.putIfAbsent(shuffleId, 0);
            this.shuffleIdToNumMapTasks.putIfAbsent(shuffleId, dependency.rdd().partitions().length);
            LOG.info("RegisterShuffle with ShuffleId[" + shuffleId + "], partitionNum is 0, return the empty RssShuffleHandle directly");
            Broadcast<ShuffleHandleInfo> hdlInfoBd = RssSparkShuffleUtils.broadcastShuffleHdlInfo(RssSparkShuffleUtils.getActiveSparkContext(), shuffleId, Collections.emptyMap(), RemoteStorageInfo.EMPTY_REMOTE_STORAGE);
            return new RssShuffleHandle<K, V, C>(shuffleId, this.appId, dependency.rdd().getNumPartitions(), dependency, hdlInfoBd);
        }
        String storageType = this.sparkConf.get(RssSparkConfig.RSS_STORAGE_TYPE.key());
        RemoteStorageInfo defaultRemoteStorage = new RemoteStorageInfo(this.sparkConf.get(RssSparkConfig.RSS_REMOTE_STORAGE_PATH.key(), ""));
        RemoteStorageInfo remoteStorage = ClientUtils.fetchRemoteStorage(this.appId, defaultRemoteStorage, this.dynamicConfEnabled, storageType, this.shuffleWriteClient);
        int partitionNumPerRange = (Integer)this.sparkConf.get(RssSparkConfig.RSS_PARTITION_NUM_PER_RANGE);
        Set<String> assignmentTags = RssSparkShuffleUtils.getAssignmentTags(this.sparkConf);
        ClientUtils.validateClientType(this.clientType);
        assignmentTags.add(this.clientType);
        int requiredShuffleServerNumber = RssSparkShuffleUtils.getRequiredShuffleServerNumber(this.sparkConf);
        long retryInterval = (Long)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_ASSIGNMENT_RETRY_INTERVAL);
        int retryTimes = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_ASSIGNMENT_RETRY_TIMES);
        try {
            partitionToServers = RetryUtils.retry(() -> {
                ShuffleAssignmentsInfo response = this.shuffleWriteClient.getShuffleAssignments(this.appId, shuffleId, dependency.partitioner().numPartitions(), partitionNumPerRange, assignmentTags, requiredShuffleServerNumber, -1);
                this.registerShuffleServers(this.appId, shuffleId, response.getServerToPartitionRanges(), remoteStorage);
                return response.getPartitionToServers();
            }, retryInterval, retryTimes);
        }
        catch (Throwable throwable) {
            throw new RssException("registerShuffle failed!", throwable);
        }
        this.startHeartbeat();
        this.shuffleIdToPartitionNum.putIfAbsent(shuffleId, dependency.partitioner().numPartitions());
        this.shuffleIdToNumMapTasks.putIfAbsent(shuffleId, dependency.rdd().partitions().length);
        Broadcast<ShuffleHandleInfo> hdlInfoBd = RssSparkShuffleUtils.broadcastShuffleHdlInfo(RssSparkShuffleUtils.getActiveSparkContext(), shuffleId, partitionToServers, remoteStorage);
        LOG.info("RegisterShuffle with ShuffleId[" + shuffleId + "], partitionNum[" + partitionToServers.size() + "]");
        return new RssShuffleHandle<K, V, C>(shuffleId, this.appId, numMaps, dependency, hdlInfoBd);
    }

    private void startHeartbeat() {
        this.shuffleWriteClient.registerApplicationInfo(this.appId, this.heartbeatTimeout, this.user);
        if (!this.sparkConf.getBoolean(RssSparkConfig.RSS_TEST_FLAG.key(), false) && !this.heartbeatStarted) {
            this.heartBeatScheduledExecutorService.scheduleAtFixedRate(() -> {
                try {
                    this.shuffleWriteClient.sendAppHeartbeat(this.appId, this.heartbeatTimeout);
                    LOG.info("Finish send heartbeat to coordinator and servers");
                }
                catch (Exception e) {
                    LOG.warn("Fail to send heartbeat to coordinator and servers", (Throwable)e);
                }
            }, this.heartbeatInterval / 2L, this.heartbeatInterval, TimeUnit.MILLISECONDS);
            this.heartbeatStarted = true;
        }
    }

    @VisibleForTesting
    protected void registerShuffleServers(String appId, int shuffleId, Map<ShuffleServerInfo, List<PartitionRange>> serverToPartitionRanges, RemoteStorageInfo remoteStorage) {
        if (serverToPartitionRanges == null || serverToPartitionRanges.isEmpty()) {
            return;
        }
        LOG.info("Start to register shuffleId[" + shuffleId + "]");
        long start = System.currentTimeMillis();
        serverToPartitionRanges.entrySet().stream().forEach(entry -> this.shuffleWriteClient.registerShuffle((ShuffleServerInfo)entry.getKey(), appId, shuffleId, (List)entry.getValue(), remoteStorage, ShuffleDataDistributionType.NORMAL, this.maxConcurrencyPerPartitionToWrite));
        LOG.info("Finish register shuffleId[" + shuffleId + "] with " + (System.currentTimeMillis() - start) + " ms");
    }

    @VisibleForTesting
    protected void registerCoordinator() {
        String coordinators = this.sparkConf.get(RssSparkConfig.RSS_COORDINATOR_QUORUM.key());
        LOG.info("Registering coordinators {}", (Object)coordinators);
        this.shuffleWriteClient.registerCoordinators(coordinators);
    }

    public CompletableFuture<Long> sendData(AddBlockEvent event) {
        if (this.dataPusher != null && event != null) {
            return this.dataPusher.send(event);
        }
        return new CompletableFuture<Long>();
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, int mapId, TaskContext context) {
        if (handle instanceof RssShuffleHandle) {
            RssShuffleHandle rssHandle = (RssShuffleHandle)handle;
            this.appId = rssHandle.getAppId();
            this.dataPusher.setRssAppId(this.appId);
            int shuffleId = rssHandle.getShuffleId();
            String taskId = "" + context.taskAttemptId() + "_" + context.attemptNumber();
            ShuffleWriteMetrics writeMetrics = context.taskMetrics().shuffleWriteMetrics();
            return new RssShuffleWriter(rssHandle.getAppId(), shuffleId, taskId, context.taskAttemptId(), writeMetrics, this, this.sparkConf, this.shuffleWriteClient, rssHandle, this::markFailedTask, context);
        }
        throw new RssException("Unexpected ShuffleHandle:" + handle.getClass().getName());
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context) {
        if (handle instanceof RssShuffleHandle) {
            RssShuffleHandle rssShuffleHandle = (RssShuffleHandle)handle;
            int partitionNumPerRange = (Integer)this.sparkConf.get(RssSparkConfig.RSS_PARTITION_NUM_PER_RANGE);
            int partitionNum = rssShuffleHandle.getDependency().partitioner().numPartitions();
            int shuffleId = rssShuffleHandle.getShuffleId();
            long start = System.currentTimeMillis();
            Roaring64NavigableMap taskIdBitmap = this.getExpectedTasks(shuffleId, startPartition, endPartition);
            LOG.info("Get taskId cost " + (System.currentTimeMillis() - start) + " ms, and request expected blockIds from " + taskIdBitmap.getLongCardinality() + " tasks for shuffleId[" + shuffleId + "], partitionId[" + startPartition + "]");
            start = System.currentTimeMillis();
            Map<Integer, List<ShuffleServerInfo>> partitionToServers = rssShuffleHandle.getPartitionToServers();
            Roaring64NavigableMap blockIdBitmap = this.getShuffleResult(this.clientType, Sets.newHashSet((Iterable)partitionToServers.get(startPartition)), rssShuffleHandle.getAppId(), shuffleId, startPartition, context.stageAttemptNumber());
            LOG.info("Get shuffle blockId cost " + (System.currentTimeMillis() - start) + " ms, and get " + blockIdBitmap.getLongCardinality() + " blockIds for shuffleId[" + shuffleId + "], partitionId[" + startPartition + "]");
            RemoteStorageInfo shuffleRemoteStorageInfo = rssShuffleHandle.getRemoteStorage();
            LOG.info("Shuffle reader using remote storage {}", (Object)shuffleRemoteStorageInfo);
            String shuffleRemoteStoragePath = shuffleRemoteStorageInfo.getPath();
            Configuration readerHadoopConf = RssSparkShuffleUtils.getRemoteStorageHadoopConf(this.sparkConf, shuffleRemoteStorageInfo);
            return new RssShuffleReader(startPartition, endPartition, context, rssShuffleHandle, shuffleRemoteStoragePath, readerHadoopConf, partitionNumPerRange, partitionNum, blockIdBitmap, taskIdBitmap, RssSparkConfig.toRssConf(this.sparkConf));
        }
        throw new RssException("Unexpected ShuffleHandle:" + handle.getClass().getName());
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, int startMapId, int endMapId) {
        return null;
    }

    public boolean unregisterShuffle(int shuffleId) {
        try {
            if (SparkEnv.get().executorId().equals("driver")) {
                this.shuffleWriteClient.unregisterShuffle(this.appId, shuffleId);
                this.shuffleIdToNumMapTasks.remove(shuffleId);
                this.shuffleIdToPartitionNum.remove(shuffleId);
                if (this.service != null) {
                    this.service.unregisterShuffle(shuffleId);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Errors on unregister to remote shuffle-servers", (Throwable)e);
        }
        return true;
    }

    public void stop() {
        if (this.heartBeatScheduledExecutorService != null) {
            this.heartBeatScheduledExecutorService.shutdownNow();
        }
        if (this.dataPusher != null) {
            try {
                this.dataPusher.close();
            }
            catch (IOException e) {
                LOG.warn("Errors on closing data pusher", (Throwable)e);
            }
        }
        if (this.shuffleWriteClient != null) {
            this.shuffleWriteClient.unregisterShuffle(this.appId);
            this.shuffleWriteClient.close();
        }
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        throw new RssException("RssShuffleManager.shuffleBlockResolver is not implemented");
    }

    private Roaring64NavigableMap getExpectedTasks(int shuffleId, int startPartition, int endPartition) {
        Roaring64NavigableMap taskIdBitmap = Roaring64NavigableMap.bitmapOf(new long[0]);
        Iterator mapStatusIter = SparkEnv.get().mapOutputTracker().getMapSizesByExecutorId(shuffleId, startPartition, endPartition).toIterator();
        while (mapStatusIter.hasNext()) {
            Tuple2 tuple2 = (Tuple2)mapStatusIter.next();
            Option topologyInfo = ((BlockManagerId)tuple2._1()).topologyInfo();
            if (topologyInfo.isDefined()) {
                taskIdBitmap.addLong(Long.parseLong((String)((BlockManagerId)tuple2._1()).topologyInfo().get()));
                continue;
            }
            throw new RssException("Can't get expected taskAttemptId");
        }
        LOG.info("Got result from MapStatus for expected tasks " + taskIdBitmap.getLongCardinality());
        return taskIdBitmap;
    }

    public Set<Long> getFailedBlockIds(String taskId) {
        Set<Long> result = this.taskToFailedBlockIds.get(taskId);
        if (result == null) {
            result = Sets.newHashSet();
        }
        return result;
    }

    public Set<Long> getSuccessBlockIds(String taskId) {
        Set<Long> result = this.taskToSuccessBlockIds.get(taskId);
        if (result == null) {
            result = Sets.newHashSet();
        }
        return result;
    }

    @VisibleForTesting
    public void addFailedBlockIds(String taskId, Set<Long> blockIds) {
        if (this.taskToFailedBlockIds.get(taskId) == null) {
            this.taskToFailedBlockIds.put(taskId, Sets.newHashSet());
        }
        this.taskToFailedBlockIds.get(taskId).addAll(blockIds);
    }

    @VisibleForTesting
    public void addSuccessBlockIds(String taskId, Set<Long> blockIds) {
        if (this.taskToSuccessBlockIds.get(taskId) == null) {
            this.taskToSuccessBlockIds.put(taskId, Sets.newHashSet());
        }
        this.taskToSuccessBlockIds.get(taskId).addAll(blockIds);
    }

    public void clearTaskMeta(String taskId) {
        this.taskToSuccessBlockIds.remove(taskId);
        this.taskToFailedBlockIds.remove(taskId);
    }

    @VisibleForTesting
    public SparkConf getSparkConf() {
        return this.sparkConf;
    }

    @VisibleForTesting
    public void setAppId(String appId) {
        this.appId = appId;
    }

    public boolean markFailedTask(String taskId) {
        LOG.info("Mark the task: {} failed.", (Object)taskId);
        this.failedTaskIds.add(taskId);
        return true;
    }

    public boolean isValidTask(String taskId) {
        return !this.failedTaskIds.contains(taskId);
    }

    public DataPusher getDataPusher() {
        return this.dataPusher;
    }

    public void setDataPusher(DataPusher dataPusher) {
        this.dataPusher = dataPusher;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public int getMaxFetchFailures() {
        String TASK_MAX_FAILURE = "spark.task.maxFailures";
        return Math.max(1, this.sparkConf.getInt("spark.task.maxFailures", 4) - 1);
    }

    @Override
    public int getPartitionNum(int shuffleId) {
        return this.shuffleIdToPartitionNum.getOrDefault(shuffleId, 0);
    }

    @Override
    public int getNumMaps(int shuffleId) {
        return this.shuffleIdToNumMapTasks.getOrDefault(shuffleId, 0);
    }

    private Roaring64NavigableMap getShuffleResult(String clientType, Set<ShuffleServerInfo> shuffleServerInfoSet, String appId, int shuffleId, int partitionId, int stageAttemptId) {
        try {
            return this.shuffleWriteClient.getShuffleResult(clientType, shuffleServerInfoSet, appId, shuffleId, partitionId);
        }
        catch (RssFetchFailedException e) {
            throw RssSparkShuffleUtils.reportRssFetchFailedException(e, this.sparkConf, appId, shuffleId, stageAttemptId, Sets.newHashSet(partitionId));
        }
    }
}

