/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.handle;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uniffle.common.netty.client.RpcResponseCallback;
import org.apache.uniffle.common.netty.handle.MessageHandler;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.io.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportResponseHandler
extends MessageHandler<RpcResponse> {
    private static final Logger logger = LoggerFactory.getLogger(TransportResponseHandler.class);
    private Map<Long, RpcResponseCallback> outstandingRpcRequests;
    private Channel channel;
    private final AtomicLong timeOfLastRequestNs;

    public TransportResponseHandler(Channel channel) {
        this.channel = channel;
        this.outstandingRpcRequests = new ConcurrentHashMap<Long, RpcResponseCallback>();
        this.timeOfLastRequestNs = new AtomicLong(0L);
    }

    public void addResponseCallback(long requestId, RpcResponseCallback callback) {
        this.updateTimeOfLastRequest();
        if (this.outstandingRpcRequests.containsKey(requestId)) {
            logger.warn("[addRpcRequest] requestId {} already exists!", (Object)requestId);
        }
        this.outstandingRpcRequests.put(requestId, callback);
    }

    public void removeRpcRequest(long requestId) {
        this.outstandingRpcRequests.remove(requestId);
    }

    @Override
    public void handle(RpcResponse message) throws Exception {
        RpcResponseCallback listener = this.outstandingRpcRequests.get(message.getRequestId());
        if (listener == null) {
            logger.error("Ignoring response from {} since it is not outstanding, {} {}", new Object[]{NettyUtils.getRemoteAddress(this.channel), message.type(), message.getRequestId()});
        } else {
            listener.onSuccess(message);
        }
    }

    @Override
    public void channelActive() {
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        if (this.numOutstandingRequests() > 0) {
            String remoteAddress = NettyUtils.getRemoteAddress(this.channel);
            logger.error("Still have {} requests outstanding when connection from {} is closed", (Object)this.numOutstandingRequests(), (Object)remoteAddress);
            this.failOutstandingRequests(cause);
        }
    }

    @Override
    public void channelInactive() {
        if (this.numOutstandingRequests() > 0) {
            String remoteAddress = NettyUtils.getRemoteAddress(this.channel);
            logger.error("Still have {} requests outstanding when connection from {} is closed", (Object)this.numOutstandingRequests(), (Object)remoteAddress);
            this.failOutstandingRequests(new IOException("Connection from " + remoteAddress + " closed"));
        }
    }

    public int numOutstandingRequests() {
        return this.outstandingRpcRequests.size();
    }

    private void failOutstandingRequests(Throwable cause) {
        for (Map.Entry<Long, RpcResponseCallback> entry : this.outstandingRpcRequests.entrySet()) {
            try {
                entry.getValue().onFailure(cause);
            }
            catch (Exception e) {
                logger.warn("RpcResponseCallback.onFailure throws exception", (Throwable)e);
            }
        }
        this.outstandingRpcRequests.clear();
    }

    public long getTimeOfLastRequestNs() {
        return this.timeOfLastRequestNs.get();
    }

    public void updateTimeOfLastRequest() {
        this.timeOfLastRequestNs.set(System.nanoTime());
    }
}

