/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.nio.ByteBuffer;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.shaded.io.netty.buffer.Unpooled;

public class ShuffleIndexResult {
    private final ManagedBuffer buffer;
    private long dataFileLen;

    public ShuffleIndexResult() {
        this(ByteBuffer.wrap(new byte[0]), -1L);
    }

    public ShuffleIndexResult(byte[] data, long dataFileLen) {
        this(data != null ? ByteBuffer.wrap(data) : null, dataFileLen);
    }

    public ShuffleIndexResult(ByteBuffer data, long dataFileLen) {
        this.buffer = new NettyManagedBuffer(data != null ? Unpooled.wrappedBuffer(data) : Unpooled.EMPTY_BUFFER);
        this.dataFileLen = dataFileLen;
    }

    public ShuffleIndexResult(ManagedBuffer buffer, long dataFileLen) {
        this.buffer = buffer;
        this.dataFileLen = dataFileLen;
    }

    public byte[] getData() {
        if (this.buffer == null) {
            return null;
        }
        if (this.buffer.nioByteBuffer().hasArray()) {
            return this.buffer.nioByteBuffer().array();
        }
        return ByteBufUtils.readBytes(this.buffer.byteBuf());
    }

    public ByteBuffer getIndexData() {
        return this.buffer.nioByteBuffer();
    }

    public long getDataFileLen() {
        return this.dataFileLen;
    }

    public boolean isEmpty() {
        return this.buffer == null || this.buffer.size() == 0;
    }

    public void release() {
        if (this.buffer != null) {
            this.buffer.release();
        }
    }

    public ManagedBuffer getManagedBuffer() {
        return this.buffer;
    }
}

