/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.request;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.proto.RssProtos;

public class RssReportShuffleWriteFailureRequest {
    private String appId;
    private int shuffleId;
    private int stageAttemptNumber;
    private List<ShuffleServerInfo> shuffleServerInfos;
    private String exception;

    public RssReportShuffleWriteFailureRequest(String appId, int shuffleId, int stageAttemptNumber, List<ShuffleServerInfo> shuffleServerInfos, String exception) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.stageAttemptNumber = stageAttemptNumber;
        this.shuffleServerInfos = shuffleServerInfos;
        this.exception = exception;
    }

    public RssProtos.ReportShuffleWriteFailureRequest toProto() {
        ArrayList shuffleServerIds = Lists.newArrayList();
        for (ShuffleServerInfo shuffleServerInfo : this.shuffleServerInfos) {
            shuffleServerIds.add(RssProtos.ShuffleServerId.newBuilder().setId(shuffleServerInfo.getId()).setPort(shuffleServerInfo.getGrpcPort()).setIp(shuffleServerInfo.getHost()).build());
        }
        RssProtos.ReportShuffleWriteFailureRequest.Builder builder = RssProtos.ReportShuffleWriteFailureRequest.newBuilder();
        builder.setAppId(this.appId).setShuffleId(this.shuffleId).setStageAttemptNumber(this.stageAttemptNumber).addAllShuffleServerIds((Iterable)shuffleServerIds);
        if (this.exception != null) {
            builder.setException(this.exception);
        }
        return builder.build();
    }
}

