/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.conf;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.coordinator.conf.ClientConf;
import org.apache.uniffle.coordinator.conf.ClientConfParser;
import org.yaml.snakeyaml.Yaml;

public class YamlClientConfParser
implements ClientConfParser {
    private static final String RSS_CLIENT_CONF_KEY = "rssClientConf";
    private static final String REMOTE_STORAGE_INFOS_KEY = "remoteStorageInfos";

    @Override
    public ClientConf tryParse(InputStream fileInputStream) throws Exception {
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.load(IOUtils.toString((InputStream)fileInputStream, (Charset)StandardCharsets.UTF_8));
        Object rssClientConfRaw = data.get(RSS_CLIENT_CONF_KEY);
        Map<String, String> rssConfKVs = rssClientConfRaw == null ? Collections.emptyMap() : this.parseKVItems(rssClientConfRaw);
        Map remoteStorageInfosRaw = data.getOrDefault(REMOTE_STORAGE_INFOS_KEY, Collections.emptyMap());
        HashMap<String, RemoteStorageInfo> remoteStorageInfoMap = new HashMap<String, RemoteStorageInfo>();
        for (Map.Entry entry : remoteStorageInfosRaw.entrySet()) {
            String remotePath = (String)entry.getKey();
            Map<String, String> kvs = this.parseKVItems(entry.getValue());
            remoteStorageInfoMap.put(remotePath, new RemoteStorageInfo(remotePath, kvs));
        }
        return new ClientConf(rssConfKVs, remoteStorageInfoMap);
    }

    private Map<String, String> parseKVItems(Object confRaw) throws Exception {
        if (confRaw instanceof Map) {
            return ((Map)confRaw).entrySet().stream().collect(Collectors.toMap(x -> String.valueOf(x.getKey()), x -> String.valueOf(x.getValue())));
        }
        if (confRaw instanceof String) {
            Configuration conf = new Configuration(false);
            conf.addResource(IOUtils.toInputStream((String)((String)confRaw)));
            HashMap<String, String> kvs = new HashMap<String, String>();
            for (Map.Entry entry : conf) {
                kvs.put((String)entry.getKey(), (String)entry.getValue());
            }
            return kvs;
        }
        throw new Exception("No such supported format, only can be 'key : val' or xml.");
    }
}

