/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty;

import java.util.LinkedList;
import org.apache.uniffle.common.netty.FrameDecoder;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.base.Preconditions;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.CompositeByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.EmptyByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.Unpooled;
import org.apache.uniffle.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.uniffle.shaded.io.netty.channel.ChannelInboundHandlerAdapter;

public class TransportFrameDecoder
extends ChannelInboundHandlerAdapter
implements FrameDecoder {
    private int msgSize = -1;
    private int bodySize = -1;
    private Message.Type curType = Message.Type.UNKNOWN_TYPE;
    private ByteBuf headerBuf = Unpooled.buffer(9, 9);
    private static final int MAX_FRAME_SIZE = Integer.MAX_VALUE;
    private static final int UNKNOWN_FRAME_SIZE = -1;
    private final LinkedList<ByteBuf> buffers = new LinkedList();
    private long totalSize = 0L;
    private long nextFrameSize = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object data) {
        ByteBuf frame;
        ByteBuf in = (ByteBuf)data;
        this.buffers.add(in);
        this.totalSize += (long)in.readableBytes();
        while (!this.buffers.isEmpty() && (frame = this.decodeNext()) != null) {
            Message msg = null;
            try {
                msg = Message.decode(this.curType, frame);
            }
            finally {
                if (TransportFrameDecoder.shouldRelease(msg)) {
                    frame.release();
                }
            }
            ctx.fireChannelRead(msg);
            this.clear();
        }
    }

    @VisibleForTesting
    static boolean shouldRelease(Message msg) {
        if (msg == null || msg.body() == null || msg.body().byteBuf() == null) {
            return true;
        }
        return msg.body().byteBuf() instanceof EmptyByteBuf;
    }

    private void clear() {
        this.curType = Message.Type.UNKNOWN_TYPE;
        this.msgSize = -1;
        this.bodySize = -1;
        this.headerBuf.clear();
    }

    private long decodeFrameSize() {
        if (this.nextFrameSize != -1L || this.totalSize < 9L) {
            return this.nextFrameSize;
        }
        ByteBuf first = this.buffers.getFirst();
        if (first.readableBytes() >= 9) {
            this.msgSize = first.readInt();
            this.curType = Message.Type.decode(first);
            this.bodySize = first.readInt();
            this.nextFrameSize = this.msgSize + this.bodySize;
            this.totalSize -= 9L;
            if (!first.isReadable()) {
                this.buffers.removeFirst().release();
            }
            return this.nextFrameSize;
        }
        while (this.headerBuf.readableBytes() < 9) {
            ByteBuf next = this.buffers.getFirst();
            int toRead = Math.min(next.readableBytes(), 9 - this.headerBuf.readableBytes());
            this.headerBuf.writeBytes(next, toRead);
            if (next.isReadable()) continue;
            this.buffers.removeFirst().release();
        }
        this.msgSize = this.headerBuf.readInt();
        this.curType = Message.Type.decode(this.headerBuf);
        this.bodySize = this.headerBuf.readInt();
        this.nextFrameSize = this.msgSize + this.bodySize;
        this.totalSize -= 9L;
        return this.nextFrameSize;
    }

    private ByteBuf decodeNext() {
        ByteBuf next;
        int remaining;
        long frameSize = this.decodeFrameSize();
        if (frameSize == -1L || this.totalSize < frameSize) {
            return null;
        }
        this.nextFrameSize = -1L;
        Preconditions.checkArgument(frameSize < Integer.MAX_VALUE, "Too large frame: %s", frameSize);
        Preconditions.checkArgument(frameSize > 0L, "Frame length should be positive: %s", frameSize);
        if (this.buffers.getFirst().readableBytes() >= remaining) {
            return this.nextBufferForFrame(remaining);
        }
        CompositeByteBuf frame = this.buffers.getFirst().alloc().compositeBuffer(Integer.MAX_VALUE);
        for (remaining = (int)frameSize; remaining > 0; remaining -= next.readableBytes()) {
            next = this.nextBufferForFrame(remaining);
            frame.addComponent(next).writerIndex(frame.writerIndex() + next.readableBytes());
        }
        assert (remaining == 0);
        return frame;
    }

    private ByteBuf nextBufferForFrame(int bytesToRead) {
        ByteBuf frame;
        ByteBuf buf = this.buffers.getFirst();
        if (buf.readableBytes() > bytesToRead) {
            frame = buf.retain().readSlice(bytesToRead);
            this.totalSize -= (long)bytesToRead;
        } else {
            frame = buf;
            this.buffers.removeFirst();
            this.totalSize -= (long)frame.readableBytes();
        }
        return frame;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        for (ByteBuf b : this.buffers) {
            b.release();
        }
        this.buffers.clear();
        this.headerBuf.release();
        super.handlerRemoved(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
    }
}

