/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.dashboard.web;

import java.net.BindException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.apache.uniffle.common.Arguments;
import org.apache.uniffle.common.util.ExitUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.dashboard.web.config.DashboardConf;
import org.apache.uniffle.dashboard.web.proxy.WebProxyServlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class JettyServerFront {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerFront.class);
    private DashboardConf conf;
    private Server server;
    private int httpPort;

    public JettyServerFront(DashboardConf coordinatorConf) {
        this.conf = coordinatorConf;
        this.initialization();
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments();
        CommandLine commandLine = new CommandLine((Object)arguments);
        commandLine.parseArgs(args);
        String configFile = arguments.getConfigFile();
        LOG.info("Start to init dashboard http server using config {}", (Object)configFile);
        DashboardConf coodConf = new DashboardConf(configFile);
        coodConf.setString("reconfigurable.file.name", configFile);
        JettyServerFront jettyServerFront = new JettyServerFront(coodConf);
        jettyServerFront.start();
    }

    private void initialization() {
        this.httpPort = this.conf.getInteger(DashboardConf.DASHBOARD_HTTP_PORT);
        ExecutorThreadPool threadPool = this.createThreadPool(this.conf);
        this.server = new Server((ThreadPool)threadPool);
        this.server.setStopAtShutdown(true);
        this.server.setStopTimeout(this.conf.getLong(DashboardConf.DASHBOARD_STOP_TIMEOUT));
        this.server.addBean((Object)new ScheduledExecutorScheduler("jetty-thread-pool", true));
        this.setRootServletHandler();
        HttpConfiguration httpConfig = new HttpConfiguration();
        this.addHttpConnector(this.httpPort, httpConfig, this.conf.getLong(DashboardConf.DASHBOARD_IDLE_TIMEOUT));
    }

    private void setRootServletHandler() {
        HandlerList handlers = new HandlerList();
        ResourceHandler resourceHandler = JettyServerFront.addResourceHandler();
        String coordinatorWebAddress = this.conf.getString(DashboardConf.COORDINATOR_WEB_ADDRESS);
        ServletContextHandler servletContextHandler = JettyServerFront.addProxyHandler(coordinatorWebAddress);
        handlers.setHandlers(new Handler[]{resourceHandler, servletContextHandler});
        this.server.setHandler((Handler)handlers);
    }

    private static ResourceHandler addResourceHandler() {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setBaseResource(Resource.newResource((URL)JettyServerFront.class.getClassLoader().getResource("static")));
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        return resourceHandler;
    }

    private static ServletContextHandler addProxyHandler(String coordinatorWebAddress) {
        WebProxyServlet proxyServlet = new WebProxyServlet(coordinatorWebAddress);
        ServletHolder holder = new ServletHolder((Servlet)proxyServlet);
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.addServlet(holder, "/api/*");
        return contextHandler;
    }

    private void addHttpConnector(int port, HttpConfiguration httpConfig, long idleTimeout) {
        ServerConnector httpConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        httpConnector.setPort(port);
        httpConnector.setIdleTimeout(idleTimeout);
        this.server.addConnector((Connector)httpConnector);
    }

    private ExecutorThreadPool createThreadPool(DashboardConf conf) {
        int corePoolSize = conf.getInteger(DashboardConf.DASHBOARD_CORE_POOL_SIZE);
        int maxPoolSize = conf.getInteger(DashboardConf.DASHBOARD_MAX_POOL_SIZE);
        ExecutorThreadPool pool = new ExecutorThreadPool((ExecutorService)new ThreadPoolExecutor(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.getThreadFactory((String)"DashboardServer")));
        return pool;
    }

    public void start() {
        try {
            this.server.start();
            this.server.join();
        }
        catch (BindException e) {
            ExitUtils.terminate((int)1, (String)"Fail to dashboard http server", (Throwable)e, (Logger)LOG);
        }
        catch (Exception e) {
            ExitUtils.terminate((int)1, (String)"Fail to start dashboard http server", (Throwable)e, (Logger)LOG);
        }
        LOG.info("Dashboard http server started, listening on port {}", (Object)this.httpPort);
    }
}

