/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.org.roaringbitmap.buffer;

import org.apache.uniffle.shaded.org.roaringbitmap.PeekableCharIterator;
import org.apache.uniffle.shaded.org.roaringbitmap.PeekableIntIterator;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.BufferUtil;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MappeableArrayContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MappeableArrayContainerCharIterator;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MappeableBitmapContainerCharIterator;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MappeableContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MappeableRunContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MappeableRunContainerCharIterator;

public class BufferIntIteratorFlyweight
implements PeekableIntIterator {
    private int hs;
    private PeekableCharIterator iter;
    private MappeableArrayContainerCharIterator arrIter = new MappeableArrayContainerCharIterator();
    private MappeableBitmapContainerCharIterator bitmapIter = new MappeableBitmapContainerCharIterator();
    private MappeableRunContainerCharIterator runIter = new MappeableRunContainerCharIterator();
    private int pos;
    private ImmutableRoaringBitmap roaringBitmap = null;

    public BufferIntIteratorFlyweight() {
    }

    public BufferIntIteratorFlyweight(ImmutableRoaringBitmap r) {
        this.wrap(r);
    }

    @Override
    public PeekableIntIterator clone() {
        try {
            BufferIntIteratorFlyweight x = (BufferIntIteratorFlyweight)super.clone();
            if (this.iter != null) {
                x.iter = this.iter.clone();
            }
            return x;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.roaringBitmap.highLowContainer.size();
    }

    @Override
    public int next() {
        int x = this.iter.nextAsInt() | this.hs;
        if (!this.iter.hasNext()) {
            ++this.pos;
            this.nextContainer();
        }
        return x;
    }

    private void nextContainer() {
        if (this.pos < this.roaringBitmap.highLowContainer.size()) {
            MappeableContainer container = this.roaringBitmap.highLowContainer.getContainerAtIndex(this.pos);
            if (container instanceof MappeableBitmapContainer) {
                this.bitmapIter.wrap((MappeableBitmapContainer)container);
                this.iter = this.bitmapIter;
            } else if (container instanceof MappeableRunContainer) {
                this.runIter.wrap((MappeableRunContainer)container);
                this.iter = this.runIter;
            } else {
                this.arrIter.wrap((MappeableArrayContainer)container);
                this.iter = this.arrIter;
            }
            this.hs = this.roaringBitmap.highLowContainer.getKeyAtIndex(this.pos) << 16;
        }
    }

    public void wrap(ImmutableRoaringBitmap r) {
        this.hs = 0;
        this.pos = 0;
        this.roaringBitmap = r;
        this.nextContainer();
    }

    @Override
    public void advanceIfNeeded(int minval) {
        while (this.hasNext() && this.hs >>> 16 < minval >>> 16) {
            ++this.pos;
            this.nextContainer();
        }
        if (this.hasNext() && this.hs >>> 16 == minval >>> 16) {
            this.iter.advanceIfNeeded(BufferUtil.lowbits(minval));
            if (!this.iter.hasNext()) {
                ++this.pos;
                this.nextContainer();
            }
        }
    }

    @Override
    public int peekNext() {
        return this.iter.peekNext() | this.hs;
    }
}

