/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;

public class HttpSenderOverHTTP
extends HttpSender {
    private final HttpGenerator generator = new HttpGenerator();
    private boolean shutdown;

    public HttpSenderOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange exchange, HttpContent content, Callback callback) {
        try {
            new HeadersCallback(exchange, content, callback).iterate();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            callback.failed(x);
        }
    }

    @Override
    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        try {
            HttpClient client = this.getHttpChannel().getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            ByteBuffer chunk = null;
            block9: while (true) {
                ByteBuffer contentBuffer = content.getByteBuffer();
                boolean lastContent = content.isLast();
                HttpGenerator.Result result = this.generator.generateRequest(null, null, chunk, contentBuffer, lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated content ({} bytes) - {}/{}", new Object[]{contentBuffer == null ? -1 : contentBuffer.remaining(), result, this.generator});
                }
                switch (result) {
                    case NEED_CHUNK: {
                        chunk = bufferPool.acquire(12, false);
                        break;
                    }
                    case FLUSH: {
                        EndPoint endPoint = this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (chunk != null) {
                            endPoint.write((Callback)new ByteBufferRecyclerCallback(callback, bufferPool, new ByteBuffer[]{chunk}), new ByteBuffer[]{chunk, contentBuffer});
                        } else {
                            endPoint.write(callback, new ByteBuffer[]{contentBuffer});
                        }
                        return;
                    }
                    case SHUTDOWN_OUT: {
                        this.shutdownOutput();
                        break;
                    }
                    case CONTINUE: {
                        if (lastContent) continue block9;
                        callback.succeeded();
                        return;
                    }
                    case DONE: {
                        callback.succeeded();
                        return;
                    }
                    default: {
                        throw new IllegalStateException(result.toString());
                    }
                }
            }
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            callback.failed(x);
            return;
        }
    }

    @Override
    protected void reset() {
        this.generator.reset();
        super.reset();
    }

    @Override
    protected void dispose() {
        this.generator.abort();
        super.dispose();
        this.shutdownOutput();
    }

    private void shutdownOutput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request shutdown output {}", new Object[]{this.getHttpExchange().getRequest()});
        }
        this.shutdown = true;
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.generator);
    }

    private class ByteBufferRecyclerCallback
    extends Callback.Nested {
        private final ByteBufferPool pool;
        private final ByteBuffer[] buffers;

        private ByteBufferRecyclerCallback(Callback callback, ByteBufferPool pool, ByteBuffer ... buffers) {
            super(callback);
            this.pool = pool;
            this.buffers = buffers;
        }

        public void succeeded() {
            for (ByteBuffer buffer : this.buffers) {
                assert (!buffer.hasRemaining());
                this.pool.release(buffer);
            }
            super.succeeded();
        }

        public void failed(Throwable x) {
            for (ByteBuffer buffer : this.buffers) {
                this.pool.release(buffer);
            }
            super.failed(x);
        }
    }

    private class HeadersCallback
    extends IteratingCallback {
        private final HttpExchange exchange;
        private final Callback callback;
        private final MetaData.Request metaData;
        private ByteBuffer headerBuffer;
        private ByteBuffer chunkBuffer;
        private ByteBuffer contentBuffer;
        private boolean lastContent;
        private boolean generated;

        public HeadersCallback(HttpExchange exchange, HttpContent content, Callback callback) {
            super(false);
            this.exchange = exchange;
            this.callback = callback;
            HttpRequest request = exchange.getRequest();
            ContentProvider requestContent = request.getContent();
            long contentLength = requestContent == null ? -1L : requestContent.getLength();
            String path = request.getPath();
            String query = request.getQuery();
            if (query != null) {
                path = path + "?" + query;
            }
            this.metaData = new MetaData.Request(request.getMethod(), new HttpURI(path), request.getVersion(), request.getHeaders(), contentLength);
            if (!HttpSenderOverHTTP.this.expects100Continue(request)) {
                content.advance();
                this.contentBuffer = content.getByteBuffer();
                this.lastContent = content.isLast();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result;
            HttpClient client = HttpSenderOverHTTP.this.getHttpChannel().getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            block8: while (true) {
                result = HttpSenderOverHTTP.this.generator.generateRequest(this.metaData, this.headerBuffer, this.chunkBuffer, this.contentBuffer, this.lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated headers ({} bytes), chunk ({} bytes), content ({} bytes) - {}/{}", new Object[]{this.headerBuffer == null ? -1 : this.headerBuffer.remaining(), this.chunkBuffer == null ? -1 : this.chunkBuffer.remaining(), this.contentBuffer == null ? -1 : this.contentBuffer.remaining(), result, HttpSenderOverHTTP.this.generator});
                }
                switch (result) {
                    case NEED_HEADER: {
                        this.headerBuffer = bufferPool.acquire(client.getRequestBufferSize(), false);
                        continue block8;
                    }
                    case NEED_CHUNK: {
                        this.chunkBuffer = bufferPool.acquire(12, false);
                        continue block8;
                    }
                    case FLUSH: {
                        EndPoint endPoint = HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (this.chunkBuffer == null) {
                            if (this.contentBuffer == null) {
                                endPoint.write((Callback)this, new ByteBuffer[]{this.headerBuffer});
                            } else {
                                endPoint.write((Callback)this, new ByteBuffer[]{this.headerBuffer, this.contentBuffer});
                            }
                        } else if (this.contentBuffer == null) {
                            endPoint.write((Callback)this, new ByteBuffer[]{this.headerBuffer, this.chunkBuffer});
                        } else {
                            endPoint.write((Callback)this, new ByteBuffer[]{this.headerBuffer, this.chunkBuffer, this.contentBuffer});
                        }
                        this.generated = true;
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        HttpSenderOverHTTP.this.shutdownOutput();
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        if (this.generated) return IteratingCallback.Action.SUCCEEDED;
                        continue block8;
                    }
                    case DONE: {
                        if (!this.generated) throw new HttpRequestException("Could not generate headers", this.exchange.getRequest());
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                }
                break;
            }
            throw new IllegalStateException(result.toString());
        }

        public void succeeded() {
            this.release();
            super.succeeded();
        }

        public void failed(Throwable x) {
            this.release();
            this.callback.failed(x);
            super.failed(x);
        }

        protected void onCompleteSuccess() {
            super.onCompleteSuccess();
            this.callback.succeeded();
        }

        private void release() {
            HttpClient client = HttpSenderOverHTTP.this.getHttpChannel().getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            bufferPool.release(this.headerBuffer);
            this.headerBuffer = null;
            if (this.chunkBuffer != null) {
                bufferPool.release(this.chunkBuffer);
            }
            this.chunkBuffer = null;
        }
    }
}

