/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http.optional;

import groovy.util.XmlSlurper;
import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.FromServer;
import groovyx.net.http.NativeHandlers;
import groovyx.net.http.ToServer;
import groovyx.net.http.TransportingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.cyberneko.html.parsers.SAXParser;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Html {
    public static final Supplier<BiFunction<ChainedHttpConfig, FromServer, Object>> neckoParserSupplier = () -> Html::neckoParse;
    public static final Supplier<BiConsumer<ChainedHttpConfig, ToServer>> jsoupEncoderSupplier = () -> Html::jsoupEncode;
    public static final Supplier<BiFunction<ChainedHttpConfig, FromServer, Object>> jsoupParserSupplier = () -> Html::jsoupParse;

    public static Object neckoParse(ChainedHttpConfig config, FromServer fromServer) {
        try {
            SAXParser p = new SAXParser();
            p.setEntityResolver((EntityResolver)NativeHandlers.Parsers.catalogResolver);
            return new XmlSlurper((XMLReader)p).parse((Reader)new InputStreamReader(fromServer.getInputStream(), fromServer.getCharset()));
        }
        catch (IOException | SAXException ex) {
            throw new TransportingException(ex);
        }
    }

    public static Object jsoupParse(ChainedHttpConfig config, FromServer fromServer) {
        try {
            return Jsoup.parse((InputStream)fromServer.getInputStream(), (String)fromServer.getCharset().name(), (String)fromServer.getUri().toString());
        }
        catch (IOException e) {
            throw new TransportingException(e);
        }
    }

    public static void jsoupEncode(ChainedHttpConfig config, ToServer ts) {
        ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
        if (NativeHandlers.Encoders.handleRawUpload(config, ts)) {
            return;
        }
        Document document = (Document)request.actualBody();
        ts.toServer(NativeHandlers.Encoders.stringToStream(document.text(), request.actualCharset()));
    }
}

