/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.sql;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.taglibs.standard.tag.common.sql.DriverManagerAccessorSupport;

public class DriverManagerAccessor {
    public static Connection getConnection(final String jdbcURL, final String userName, final String password) throws SQLException {
        try {
            return DriverManagerAccessor.getRealConnection(jdbcURL, userName, password);
        }
        catch (SQLException sqlException) {
            try {
                return (Connection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        if (cl != null && cl != DriverManagerAccessor.class.getClassLoader()) {
                            Class<?> definedClass = DriverManagerAccessorSupport.define(cl);
                            Method method = definedClass.getDeclaredMethod("getRealConnection", String.class, String.class, String.class);
                            method.setAccessible(true);
                            return method.invoke(null, jdbcURL, userName, password);
                        }
                        throw sqlException;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw sqlException;
            }
        }
    }

    private static Connection getRealConnection(String jdbcURL, String userName, String password) throws SQLException {
        return DriverManager.getConnection(jdbcURL, userName, password);
    }

    public static Connection getConnection(final String jdbcURL) throws SQLException {
        try {
            return DriverManagerAccessor.getRealConnection(jdbcURL);
        }
        catch (SQLException sqlException) {
            try {
                return (Connection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        if (cl != null && cl != DriverManagerAccessor.class.getClassLoader()) {
                            Class<?> definedClass = DriverManagerAccessorSupport.define(cl);
                            Method method = definedClass.getDeclaredMethod("getRealConnection", String.class);
                            method.setAccessible(true);
                            return (Connection)method.invoke(null, jdbcURL);
                        }
                        throw sqlException;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw sqlException;
            }
        }
    }

    private static Connection getRealConnection(String jdbcURL) throws SQLException {
        return DriverManager.getConnection(jdbcURL);
    }
}

