/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.security.RefreshPolicy;
import org.elasticsearch.client.security.user.privileges.Role;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class CreateApiKeyRequest
implements Validatable,
ToXContentObject {
    private final String name;
    private final TimeValue expiration;
    private final List<Role> roles;
    private final RefreshPolicy refreshPolicy;

    public CreateApiKeyRequest(String name, List<Role> roles, @Nullable TimeValue expiration, @Nullable RefreshPolicy refreshPolicy) {
        if (!Strings.hasText(name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        this.name = name;
        this.roles = Objects.requireNonNull(roles, "roles may not be null");
        this.expiration = expiration;
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.getDefault() : refreshPolicy;
    }

    public String getName() {
        return this.name;
    }

    public TimeValue getExpiration() {
        return this.expiration;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.refreshPolicy, this.roles, this.expiration});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateApiKeyRequest that = (CreateApiKeyRequest)o;
        return Objects.equals(this.name, that.name) && Objects.equals((Object)this.refreshPolicy, (Object)that.refreshPolicy) && Objects.equals(this.roles, that.roles) && Objects.equals(this.expiration, that.expiration);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("name", this.name);
        if (this.expiration != null) {
            builder.field("expiration", this.expiration.getStringRep());
        }
        builder.startObject("role_descriptors");
        for (Role role : this.roles) {
            builder.startObject(role.getName());
            if (role.getApplicationPrivileges() != null) {
                builder.field(Role.APPLICATIONS.getPreferredName(), role.getApplicationPrivileges());
            }
            if (role.getClusterPrivileges() != null) {
                builder.field(Role.CLUSTER.getPreferredName(), role.getClusterPrivileges());
            }
            if (role.getGlobalPrivileges() != null) {
                builder.field(Role.GLOBAL.getPreferredName(), role.getGlobalPrivileges());
            }
            if (role.getIndicesPrivileges() != null) {
                builder.field(Role.INDICES.getPreferredName(), role.getIndicesPrivileges());
            }
            if (role.getMetadata() != null) {
                builder.field(Role.METADATA.getPreferredName(), role.getMetadata());
            }
            if (role.getRunAsPrivilege() != null) {
                builder.field(Role.RUN_AS.getPreferredName(), role.getRunAsPrivilege());
            }
            builder.endObject();
        }
        builder.endObject();
        return builder.endObject();
    }
}

