/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.util.ConversionUtil;
import org.ops4j.pax.web.service.spi.util.Path;

public class FilterModel
extends Model {
    private final Filter filter;
    private final String[] urlPatterns;
    private final String[] servletNames;
    private final Map<String, String> initParams;
    private final String name;
    private final Set<String> dispatcher = new HashSet<String>();
    private final Class<? extends Filter> filterClass;
    private final boolean asyncSupported;

    public FilterModel(ContextModel contextModel, Filter filter, String[] urlPatterns, String[] servletNames, Dictionary<String, ?> initParameter, boolean asyncSupported) {
        this(contextModel, filter, null, urlPatterns, servletNames, initParameter, asyncSupported);
    }

    public FilterModel(ContextModel contextModel, Class<? extends Filter> filterClass, String[] urlPatterns, String[] servletNames, Dictionary<String, ?> initParameter, boolean asyncSupported) {
        this(contextModel, null, filterClass, urlPatterns, servletNames, initParameter, asyncSupported);
    }

    public FilterModel(ContextModel contextModel, Filter filter, Class<? extends Filter> filterClass, String[] urlPatterns, String[] servletNames, Dictionary<String, ?> initParameter, boolean asyncSupported) {
        super(contextModel);
        if (filterClass == null) {
            NullArgumentException.validateNotNull(filter, "Filter");
        }
        if (filter == null) {
            NullArgumentException.validateNotNull(filterClass, "FilterClass");
        }
        if (urlPatterns == null && servletNames == null) {
            throw new IllegalArgumentException("Registered filter must have at least one url pattern or servlet name mapping");
        }
        this.filter = filter;
        this.filterClass = filterClass;
        this.urlPatterns = urlPatterns != null ? Path.normalizePatterns(Arrays.copyOf(urlPatterns, urlPatterns.length)) : null;
        this.servletNames = servletNames != null ? Arrays.copyOf(servletNames, servletNames.length) : null;
        this.initParams = ConversionUtil.convertToMap(initParameter);
        String idName = this.initParams.get("filter-name");
        if (idName == null) {
            idName = this.getId();
        }
        this.name = idName;
        this.initParams.remove("filter-name");
        this.asyncSupported = asyncSupported;
        this.setupDispatcher();
    }

    private void setupDispatcher() {
        String dispatches = this.initParams.get("filter-mapping-dispatcher");
        this.initParams.remove("filter-mapping-dispatcher");
        if (dispatches != null && dispatches.trim().length() > 0) {
            if (dispatches.indexOf(",") > -1) {
                StringTokenizer tok = new StringTokenizer(dispatches.trim(), ",");
                while (tok.hasMoreTokens()) {
                    String element = tok.nextToken();
                    if (element == null || element.trim().length() <= 0) continue;
                    this.dispatcher.add(DispatcherType.valueOf((String)element.trim().toUpperCase()).name());
                }
            } else {
                this.dispatcher.add(DispatcherType.valueOf((String)dispatches.trim().toUpperCase()).name());
            }
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Class<? extends Filter> getFilterClass() {
        return this.filterClass;
    }

    public String getName() {
        return this.name;
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public String[] getServletNames() {
        return this.servletNames;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public String[] getDispatcher() {
        return this.dispatcher.toArray(new String[this.dispatcher.size()]);
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterModel that = (FilterModel)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.getContextModel().getContextName(), that.getContextModel().getContextName());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getContextModel().getContextName());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "id=" + this.getId() + ",urlPatterns=" + Arrays.toString(this.urlPatterns) + ",servletNames=" + Arrays.toString(this.servletNames) + ",filter=" + this.filter + ",filterClass=" + this.filterClass + ",context=" + this.getContextModel() + "}";
    }
}

