/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.persistence.spi.PropertyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyPropertiesAction
implements ActionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyPropertiesAction.class);
    private ProfileService profileService;

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public int execute(Action action, Event event) {
        boolean atLeastOnechanged = false;
        List mandatoryPropTypeSystemTags = (List)action.getParameterValues().get("mandatoryPropTypeSystemTag");
        String singleValueStrategy = (String)action.getParameterValues().get("singleValueStrategy");
        for (Map.Entry<String, Object> entry : this.getEventPropsToCopy(action, event).entrySet()) {
            String mappedProperty = this.resolvePropertyName(entry.getKey());
            PropertyType propertyType = this.profileService.getPropertyType(mappedProperty);
            Object previousValue = event.getProfile().getProperty(mappedProperty);
            if (mandatoryPropTypeSystemTags != null && mandatoryPropTypeSystemTags.size() > 0 && (propertyType == null || propertyType.getMetadata() == null || propertyType.getMetadata().getSystemTags() == null || !propertyType.getMetadata().getSystemTags().containsAll(mandatoryPropTypeSystemTags))) continue;
            String propertyName = "properties." + mappedProperty;
            boolean changed = false;
            if (previousValue == null && propertyType == null) {
                changed = PropertyHelper.setProperty((Object)event.getProfile(), (String)propertyName, (Object)entry.getValue(), (String)"alwaysSet");
            } else {
                boolean multipleIsExpected;
                boolean propertyTypeIsMultiValued = propertyType != null && propertyType.isMultivalued() != null && propertyType.isMultivalued() != false;
                boolean bl = multipleIsExpected = previousValue != null ? previousValue instanceof List : propertyTypeIsMultiValued;
                if (multipleIsExpected) {
                    changed = PropertyHelper.setProperty((Object)event.getProfile(), (String)propertyName, (Object)entry.getValue(), (String)"addValues");
                } else if (entry.getValue() instanceof List) {
                    LOGGER.error("Impossible to copy the property of type List to the profile, either a single value already exist on the profile or the property type is declared as a single value property. Enable debug log level for more information");
                    LOGGER.debug("cannot copy property {}, because it's a List", (Object)mappedProperty);
                } else {
                    changed = PropertyHelper.setProperty((Object)event.getProfile(), (String)propertyName, (Object)entry.getValue(), (String)singleValueStrategy);
                }
            }
            atLeastOnechanged = atLeastOnechanged || changed;
        }
        return atLeastOnechanged ? 4 : 0;
    }

    private Map<String, Object> getEventPropsToCopy(Action action, Event event) {
        HashMap<String, Object> propsToCopy = new HashMap<String, Object>();
        String rootProperty = (String)action.getParameterValues().get("rootProperty");
        boolean copyEventProps = false;
        if (StringUtils.isEmpty((CharSequence)rootProperty)) {
            copyEventProps = true;
            rootProperty = "target.properties";
        }
        if (copyEventProps && event.getProperties() != null) {
            propsToCopy.putAll(event.getProperties());
        }
        try {
            Object targetProperties = BeanUtilsBean.getInstance().getPropertyUtils().getProperty((Object)event, rootProperty);
            if (targetProperties instanceof Map) {
                propsToCopy.putAll((Map)targetProperties);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to extract properties to be copied from the event to the profile using root property: {}", (Object)rootProperty, (Object)e);
        }
        return propsToCopy;
    }

    private String resolvePropertyName(String propertyName) {
        String propertyMapping = this.profileService.getPropertyTypeMapping(propertyName);
        return propertyMapping != null ? propertyMapping : propertyName;
    }
}

