/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import org.apache.felix.metatype.internal.ManagedServiceHolder;
import org.apache.felix.metatype.internal.MetaTypeServiceImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.util.tracker.ServiceTracker;

public class ManagedServiceTracker
extends ServiceTracker {
    static final String MANAGED_SERVICE = "org.osgi.service.cm.ManagedService";
    static final String MANAGED_SERVICE_FACTORY = "org.osgi.service.cm.ManagedServiceFactory";
    private static final String FILTER = "(|(objectClass=org.osgi.service.cm.ManagedService)(objectClass=org.osgi.service.cm.ManagedServiceFactory))";
    private final MetaTypeServiceImpl mts;

    public ManagedServiceTracker(BundleContext bundleContext, MetaTypeServiceImpl mts) throws InvalidSyntaxException {
        super(bundleContext, bundleContext.createFilter(FILTER), null);
        this.mts = mts;
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        if (service instanceof MetaTypeProvider) {
            ManagedServiceHolder holder = new ManagedServiceHolder(reference, (MetaTypeProvider)service);
            this.mts.addService(holder);
            return holder;
        }
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        ((ManagedServiceHolder)service).update(this.mts);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.mts.removeService((ManagedServiceHolder)service);
        this.context.ungetService(reference);
    }
}

