/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpDefaultMoveExistingFileStrategy
implements FileMoveExistingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SftpDefaultMoveExistingFileStrategy.class);

    public boolean moveExistingFile(GenericFileEndpoint endpoint, GenericFileOperations operations, String fileName) throws GenericFileOperationFailedException {
        Exchange dummy = endpoint.createExchange();
        Object parent = null;
        String onlyName = FileUtil.stripPath((String)fileName);
        dummy.getIn().setHeader("CamelFileName", (Object)fileName);
        dummy.getIn().setHeader("CamelFileNameOnly", (Object)onlyName);
        dummy.getIn().setHeader("CamelFileParent", parent);
        String to = (String)endpoint.getMoveExisting().evaluate(dummy, String.class);
        to = FileUtil.stripLeadingSeparator((String)to);
        to = ((SftpEndpoint)endpoint).getConfiguration().normalizePath(to);
        if (ObjectHelper.isEmpty((Object)to)) {
            throw new GenericFileOperationFailedException("moveExisting evaluated as empty String, cannot move existing file: " + fileName);
        }
        String dir = FileUtil.onlyPath((String)to);
        if (dir != null) {
            operations.buildDirectory(dir, false);
        }
        if (operations.existsFile(to)) {
            if (endpoint.isEagerDeleteTargetFile()) {
                LOG.trace("Deleting existing file: {}", (Object)to);
                operations.deleteFile(to);
            } else {
                throw new GenericFileOperationFailedException("Cannot move existing file from: " + fileName + " to: " + to + " as there already exists a file: " + to);
            }
        }
        LOG.trace("Moving existing file: {} to: {}", (Object)fileName, (Object)to);
        if (!operations.renameFile(fileName, to)) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + fileName + " to: " + to);
        }
        return true;
    }
}

