/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.healthcheck;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;

public class HealthCheckResponse {
    private final String name;
    private final Status status;
    private final long collectingTime;
    private final Map<String, Object> data;

    protected HealthCheckResponse(String name, Status status, long collectingTime, Map<String, Object> data) {
        this.name = name;
        this.status = status;
        this.collectingTime = collectingTime;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public long getCollectingTime() {
        return this.collectingTime;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder named(String name) {
        return new Builder().name(name);
    }

    public static HealthCheckResponse up(String name) {
        return HealthCheckResponse.named(name).up().build();
    }

    public static HealthCheckResponse live(String name) {
        return HealthCheckResponse.named(name).live().build();
    }

    public static HealthCheckResponse down(String name) {
        return HealthCheckResponse.named(name).down().build();
    }

    public static HealthCheckResponse error(String name) {
        return HealthCheckResponse.named(name).error().build();
    }

    @JsonIgnore
    public boolean isLive() {
        return this.status == Status.LIVE;
    }

    @JsonIgnore
    public boolean isUp() {
        return this.status == Status.UP;
    }

    @JsonIgnore
    public boolean isDown() {
        return this.status == Status.DOWN;
    }

    @JsonIgnore
    public boolean isError() {
        return this.status == Status.ERROR;
    }

    public static enum Status {
        DOWN,
        UP,
        LIVE,
        ERROR;

    }

    public static class Builder {
        private final long borntime = System.currentTimeMillis();
        private String name;
        private Status status = Status.DOWN;
        private final Map<String, Object> data = new LinkedHashMap<String, Object>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder withData(String key, String value) {
            this.data.put(key, value);
            return this;
        }

        public Builder withData(String key, long value) {
            this.data.put(key, value);
            return this;
        }

        public Builder withData(String key, boolean value) {
            this.data.put(key, value);
            return this;
        }

        public Builder up() {
            this.status = Status.UP;
            return this;
        }

        public Builder live() {
            this.status = Status.LIVE;
            return this;
        }

        public Builder down() {
            this.status = Status.DOWN;
            return this;
        }

        public Builder error() {
            this.status = Status.ERROR;
            return this;
        }

        public HealthCheckResponse build() {
            return new HealthCheckResponse(this.name, this.status, System.currentTimeMillis() - this.borntime, this.data.isEmpty() ? null : this.data);
        }
    }
}

