/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Item
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Item.class.getName());
    private static final long serialVersionUID = 7446061538573517071L;
    private static final Map<Class, String> itemTypeCache = new ConcurrentHashMap<Class, String>();
    protected String itemId;
    protected String itemType;
    protected String scope;
    protected Long version;
    protected Map<String, Object> systemMetadata = new HashMap<String, Object>();

    public static String getItemType(Class clazz) {
        String itemType = itemTypeCache.get(clazz);
        if (itemType != null) {
            return itemType;
        }
        try {
            itemType = (String)clazz.getField("ITEM_TYPE").get(null);
            itemTypeCache.put(clazz, itemType);
            return itemType;
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Class {} doesn't define a publicly accessible ITEM_TYPE field", (Object)clazz.getName(), (Object)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Error resolving itemType for class {}", (Object)clazz.getName(), (Object)e);
        }
        return null;
    }

    public Item() {
        this.itemType = Item.getItemType(this.getClass());
        if (this.itemType == null) {
            LOGGER.error("Item implementations must provide a public String constant named ITEM_TYPE to uniquely identify this Item for the persistence service.");
        }
    }

    public Item(String itemId) {
        this();
        this.itemId = itemId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return !(this.itemId == null ? item.itemId != null : !this.itemId.equals(item.itemId));
    }

    public int hashCode() {
        return this.itemId != null ? this.itemId.hashCode() : 0;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Object getSystemMetadata(String key) {
        return this.systemMetadata.get(key);
    }

    public void setSystemMetadata(String key, Object value) {
        this.systemMetadata.put(key, value);
    }
}

