/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.cdi.DetachEvent;
import org.apache.wicket.cdi.NonContextual;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetachEventEmitter
implements IRequestCycleListener {
    private static final Logger logger = LoggerFactory.getLogger(DetachEventEmitter.class);
    private static final MetaDataKey<Boolean> DETACH_SCHEDULED_KEY = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };
    @Inject
    Event<DetachEvent> detachEvent;

    public DetachEventEmitter() {
        NonContextual.of(DetachEventEmitter.class).postConstruct(this);
    }

    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        cycle.setMetaData(DETACH_SCHEDULED_KEY, (Object)true);
    }

    public void onDetach(RequestCycle cycle) {
        if (Boolean.TRUE.equals(cycle.getMetaData(DETACH_SCHEDULED_KEY))) {
            logger.debug("Firing Detach event {}", (Object)cycle.getRequest().getUrl());
            this.detachEvent.fire((Object)new DetachEvent());
            cycle.setMetaData(DETACH_SCHEDULED_KEY, null);
        }
    }
}

