/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.io.Resources;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.internal.tasks.testing.report.generic.GenericHtmlTestReport;
import org.gradle.api.internal.tasks.testing.report.generic.MetadataRendererRegistry;
import org.gradle.api.internal.tasks.testing.report.generic.PerRootTabRenderer;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModel;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.ReportRenderer;
import org.gradle.reporting.TabbedPageRenderer;
import org.gradle.reporting.TabsRenderer;
import org.gradle.util.Path;

final class GenericPageRenderer
extends TabbedPageRenderer<TestTreeModel> {
    private static final URL STYLE_URL = Resources.getResource(GenericPageRenderer.class, (String)"style.css");
    private final List<SerializableTestResultStore.OutputReader> outputReaders;
    private final List<String> rootDisplayNames;
    private final MetadataRendererRegistry metadataRendererRegistry;

    public static String getUrlTo(Path originatingPath, Path targetPath) {
        if (originatingPath.equals((Object)targetPath)) {
            return "#";
        }
        java.nio.file.Path relativePath = Paths.get("./" + GenericHtmlTestReport.getFilePath(originatingPath), new String[0]).getParent().relativize(Paths.get("./" + GenericHtmlTestReport.getFilePath(targetPath), new String[0]));
        StringBuilder url = new StringBuilder();
        for (java.nio.file.Path segment : relativePath) {
            url.append(UrlEscapers.urlPathSegmentEscaper().escape(segment.toString()));
            url.append('/');
        }
        return url.substring(0, url.length() - 1);
    }

    GenericPageRenderer(List<SerializableTestResultStore.OutputReader> outputReaders, List<String> rootDisplayNames, MetadataRendererRegistry metadataRendererRegistry) {
        this.outputReaders = outputReaders;
        this.rootDisplayNames = rootDisplayNames;
        this.metadataRendererRegistry = metadataRendererRegistry;
    }

    private void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        if (((TestTreeModel)this.getModel()).getPath().equals((Object)Path.ROOT)) {
            return;
        }
        htmlWriter.startElement("div").attribute("class", "breadcrumbs");
        for (Path path : ((TestTreeModel)this.getModel()).getPath().ancestors()) {
            String title = path.equals((Object)Path.ROOT) ? "all" : path.getName();
            htmlWriter.startElement("a").attribute("href", GenericPageRenderer.getUrlTo(((TestTreeModel)this.getModel()).getPath(), path)).characters((CharSequence)title).endElement();
            htmlWriter.characters((CharSequence)" > ");
        }
        htmlWriter.characters((CharSequence)((TestTreeModel)this.getModel()).getPath().getName());
        htmlWriter.endElement();
    }

    protected URL getStyleUrl() {
        return STYLE_URL;
    }

    protected String getTitle() {
        return this.buildTitle("All Results", name -> "");
    }

    protected String getPageTitle() {
        return this.buildTitle("Test results - All Results", name -> "Test results - " + name);
    }

    private String buildTitle(String rootTitle, Function<String, String> buildTitleFromName) {
        String name = ((TestTreeModel)this.getModel()).getPath().getName();
        if (name == null) {
            return rootTitle;
        }
        return buildTitleFromName.apply(name);
    }

    protected ReportRenderer<TestTreeModel, SimpleHtmlWriter> getHeaderRenderer() {
        return new ReportRenderer<TestTreeModel, SimpleHtmlWriter>(){

            public void render(TestTreeModel model, SimpleHtmlWriter htmlWriter) throws IOException {
                GenericPageRenderer.this.renderBreadcrumbs(htmlWriter);
            }
        };
    }

    protected ReportRenderer<TestTreeModel, SimpleHtmlWriter> getContentRenderer() {
        TabsRenderer rootTabsRenderer = new TabsRenderer();
        ((TestTreeModel)this.getModel()).getPerRootInfo().forEach((rootIndex, info) -> {
            final TabsRenderer tabsRenderer = new TabsRenderer();
            tabsRenderer.add("summary", (ReportRenderer)new PerRootTabRenderer.ForSummary((int)rootIndex));
            SerializableTestResultStore.OutputReader outputReader = this.outputReaders.get((int)rootIndex);
            if (outputReader.hasOutput(info.getOutputId(), TestOutputEvent.Destination.StdOut)) {
                tabsRenderer.add("standard output", (ReportRenderer)new PerRootTabRenderer.ForOutput((int)rootIndex, outputReader, TestOutputEvent.Destination.StdOut));
            }
            if (outputReader.hasOutput(info.getOutputId(), TestOutputEvent.Destination.StdErr)) {
                tabsRenderer.add("error output", (ReportRenderer)new PerRootTabRenderer.ForOutput((int)rootIndex, outputReader, TestOutputEvent.Destination.StdErr));
            }
            if (!info.getMetadatas().isEmpty()) {
                tabsRenderer.add("metadata", (ReportRenderer)new PerRootTabRenderer.ForMetadata((int)rootIndex, this.metadataRendererRegistry));
            }
            rootTabsRenderer.add(this.rootDisplayNames.get((int)rootIndex), (ReportRenderer)new ReportRenderer<TestTreeModel, SimpleHtmlWriter>(){

                public void render(TestTreeModel model, SimpleHtmlWriter output) throws IOException {
                    output.startElement("h1").characters((CharSequence)info.getResult().getDisplayName()).endElement();
                    tabsRenderer.render((Object)model, output);
                }
            });
        });
        return rootTabsRenderer;
    }
}

