/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.api.migrate;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.Scroll;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.resources.ResourceSharingIndexHandler;
import org.opensearch.security.resources.sharing.CreatedBy;
import org.opensearch.security.resources.sharing.Recipient;
import org.opensearch.security.resources.sharing.Recipients;
import org.opensearch.security.resources.sharing.ResourceSharing;
import org.opensearch.security.resources.sharing.ShareWith;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.spi.resources.ResourceProvider;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class MigrateResourceSharingInfoApiAction
extends AbstractApiAction {
    private static final Logger LOGGER = LogManager.getLogger(MigrateResourceSharingInfoApiAction.class);
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/resources/migrate")));
    private final ResourceSharingIndexHandler sharingIndexHandler;
    private final ResourcePluginInfo resourcePluginInfo;

    public MigrateResourceSharingInfoApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies, ResourceSharingIndexHandler sharingIndexHandler, ResourcePluginInfo resourcePluginInfo) {
        super(Endpoint.RESOURCE_SHARING, clusterService, threadPool, securityApiDependencies);
        this.sharingIndexHandler = sharingIndexHandler;
        this.requestHandlersBuilder.configureRequestHandlers(this::migrateApiRequestHandlers);
        this.resourcePluginInfo = resourcePluginInfo;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType<?> getConfigType() {
        return null;
    }

    private void migrateApiRequestHandlers(RequestHandler.RequestHandlersBuilder b) {
        b.withAccessHandler(this::accessHandler).allMethodsNotImplemented().override(RestRequest.Method.POST, this::handleMigrate);
    }

    boolean accessHandler(RestRequest request) {
        if (request.method() == RestRequest.Method.POST) {
            return this.securityApiDependencies.restApiAdminPrivilegesEvaluator().isCurrentUserAdminFor(this.endpoint, "migrate");
        }
        return false;
    }

    private void handleMigrate(RestChannel channel, RestRequest request, Client client) throws IOException {
        this.endpointValidator.createRequestContentValidator(new Object[0]).validate(request).map(pair -> this.loadCurrentSharingInfo(request, client)).map(this::createNewSharingRecords).valid(stats -> Responses.ok(channel, (ToXContent)stats)).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent)));
    }

    private ValidationResult<ValidationResultArg> loadCurrentSharingInfo(RestRequest request, Client client) throws IOException {
        JsonNode body = Utils.toJsonNode(request.content().utf8ToString());
        String sourceIndex = body.get("source_index").asText();
        String userNamePath = body.get("username_path").asText();
        String backendRolesPath = body.get("backend_roles_path").asText();
        String defaultOwner = body.get("default_owner").asText();
        JsonNode node = body.get("default_access_level");
        Map<String, String> typeToDefaultAccessLevel = Utils.toMapOfStrings(node);
        if (!this.resourcePluginInfo.getResourceIndicesForProtectedTypes().contains(sourceIndex)) {
            String badRequestMessage = "Invalid resource index " + sourceIndex + ".";
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage(badRequestMessage));
        }
        String typePath = null;
        for (String type : typeToDefaultAccessLevel.keySet()) {
            ResourceProvider provider = this.resourcePluginInfo.getResourceProvider(type);
            String defaultAccessLevelForType = typeToDefaultAccessLevel.get(type);
            LOGGER.info("Default access level for resource type [{}] is [{}]", (Object)type, (Object)typeToDefaultAccessLevel.get(type));
            if (provider == null) {
                String badRequestMessage = "Invalid resource type " + type + ".";
                return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage(badRequestMessage));
            }
            typePath = provider.typeField();
            ImmutableSet<String> accessLevels = this.resourcePluginInfo.flattenedForType(type).actionGroups();
            if (accessLevels.contains((Object)defaultAccessLevelForType)) continue;
            LOGGER.error("Invalid access level {} for resource sharing for resource type [{}]. Available access-levels are [{}]", (Object)defaultAccessLevelForType, (Object)type, accessLevels);
            String badRequestMessage = "Invalid access level " + defaultAccessLevelForType + " for resource sharing for resource type [" + type + "]. Available access-levels are [" + String.valueOf(accessLevels) + "]";
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage(badRequestMessage));
        }
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            SearchHit[] hits;
            ArrayList<SourceDoc> results = new ArrayList<SourceDoc>();
            Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
            SearchRequest searchRequest = new SearchRequest(new String[]{sourceIndex}).scroll(scroll).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(1000));
            SearchResponse searchResponse = (SearchResponse)client.search(searchRequest).actionGet();
            String scrollId = searchResponse.getScrollId();
            while ((hits = searchResponse.getHits().getHits()) != null && hits.length != 0) {
                for (SearchHit hit : hits) {
                    JsonNode rec = Utils.toJsonNode(hit.getSourceAsString());
                    String id = hit.getId();
                    String username = rec.at((String)(userNamePath.startsWith("/") ? userNamePath : "/" + userNamePath)).asText(null);
                    JsonNode backendRolesNode = rec.at((String)(backendRolesPath.startsWith("/") ? backendRolesPath : "/" + backendRolesPath));
                    ArrayList<String> backendRoles = new ArrayList<String>();
                    if (backendRolesNode.isArray()) {
                        for (JsonNode br : backendRolesNode) {
                            backendRoles.add(br.asText());
                        }
                    }
                    String type = typePath != null ? rec.at("/" + typePath.replace(".", "/")).asText(null) : typeToDefaultAccessLevel.keySet().iterator().next();
                    results.add(new SourceDoc(id, username, backendRoles, type));
                }
                SearchScrollRequest object = new SearchScrollRequest(scrollId).scroll(scroll);
                searchResponse = (SearchResponse)client.searchScroll(object).actionGet();
                scrollId = searchResponse.getScrollId();
            }
            ClearScrollRequest clear = new ClearScrollRequest();
            clear.addScrollId(scrollId);
            client.clearScroll(clear).actionGet();
            ValidationResult<ValidationResultArg> validationResult = ValidationResult.success(new ValidationResultArg(sourceIndex, defaultOwner, typeToDefaultAccessLevel, results));
            return validationResult;
        }
    }

    private ValidationResult<MigrationStats> createNewSharingRecords(ValidationResultArg sourceInfo) throws IOException {
        AtomicInteger migratedCount = new AtomicInteger();
        AtomicInteger skippedExisting = new AtomicInteger();
        AtomicInteger failureCount = new AtomicInteger();
        ConcurrentHashMap.KeySetView skippedNoType = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView resourcesWithDefaultOwner = ConcurrentHashMap.newKeySet();
        List<SourceDoc> docs = sourceInfo.sourceDocs;
        int total = docs.size();
        CountDownLatch migrationStatsLatch = new CountDownLatch(total);
        for (SourceDoc doc : docs) {
            String resourceId = doc.resourceId;
            if (resourceId == null) {
                failureCount.getAndIncrement();
                migrationStatsLatch.countDown();
                continue;
            }
            String type = doc.type;
            if (type == null || type.isEmpty()) {
                LOGGER.debug("Record without associated type, skipping entirely: {}", (Object)doc.resourceId);
                skippedNoType.add(doc.resourceId);
                migrationStatsLatch.countDown();
                continue;
            }
            ResourceProvider provider = this.resourcePluginInfo.getResourceProvider(type);
            try {
                String username = doc.username;
                if (username == null || username.isEmpty()) {
                    LOGGER.debug("Record {} without associated user, creating a sharing entry with default owner: {}", (Object)doc.resourceId, (Object)sourceInfo.defaultOwnerName);
                    username = sourceInfo.defaultOwnerName;
                    resourcesWithDefaultOwner.add(doc.resourceId);
                }
                CreatedBy createdBy = new CreatedBy(username);
                List<String> backendRoles = doc.backendRoles;
                ShareWith shareWith = null;
                if (!backendRoles.isEmpty()) {
                    Recipients recipients = new Recipients(Map.of(Recipient.BACKEND_ROLES, new HashSet<String>(backendRoles)));
                    shareWith = new ShareWith(Map.of(sourceInfo.typeToDefaultAccessLevel.get(doc.type), recipients));
                }
                ActionListener listener = ActionListener.wrap(entry -> {
                    if (entry != null) {
                        LOGGER.debug("Successfully migrated a resource sharing entry {} for resource {} within index {}", entry, (Object)resourceId, (Object)sourceInfo.sourceIndex);
                        migratedCount.getAndIncrement();
                    } else {
                        LOGGER.debug("Skipping migration of resource sharing record for resource {} within index {} as an entry already exists", (Object)resourceId, (Object)sourceInfo.sourceIndex);
                        skippedExisting.getAndIncrement();
                    }
                    migrationStatsLatch.countDown();
                }, e -> {
                    LOGGER.debug(e.getMessage());
                    failureCount.getAndIncrement();
                    migrationStatsLatch.countDown();
                });
                ResourceSharing sharingInfo = ResourceSharing.builder().resourceId(resourceId).createdBy(createdBy).shareWith(shareWith).resourceType(provider.resourceType()).build();
                this.sharingIndexHandler.indexResourceSharing(sourceInfo.sourceIndex, sharingInfo, (ActionListener<ResourceSharing>)listener);
            }
            catch (Exception e2) {
                LOGGER.warn("Failed indexing sharing info for [{}]: {}", (Object)resourceId, (Object)e2.getMessage());
                failureCount.getAndIncrement();
                migrationStatsLatch.countDown();
            }
        }
        try {
            migrationStatsLatch.await();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for migration to finish", ie);
        }
        String summary = String.format("Migration complete. migrated %d; skippedNoType %s; skippedExisting %s; failed %d", migratedCount.get(), skippedNoType.size(), skippedExisting.get(), failureCount.get());
        MigrationStats stats = new MigrationStats(summary, resourcesWithDefaultOwner, skippedNoType);
        return ValidationResult.success(stats);
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return MigrateResourceSharingInfoApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return MigrateResourceSharingInfoApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public RequestContentValidator createRequestContentValidator(Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return new Object[0];
                    }

                    @Override
                    public Settings settings() {
                        return MigrateResourceSharingInfoApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Set<String> mandatoryKeys() {
                        return ImmutableSet.of((Object)"source_index", (Object)"username_path", (Object)"backend_roles_path", (Object)"default_owner", (Object)"default_access_level");
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        return ImmutableMap.builder().put((Object)"source_index", (Object)RequestContentValidator.DataType.STRING).put((Object)"username_path", (Object)RequestContentValidator.DataType.STRING).put((Object)"backend_roles_path", (Object)RequestContentValidator.DataType.STRING).put((Object)"default_owner", (Object)RequestContentValidator.DataType.STRING).put((Object)"default_access_level", (Object)RequestContentValidator.DataType.OBJECT).build();
                    }
                });
            }
        };
    }

    record SourceDoc(String resourceId, String username, List<String> backendRoles, String type) {
    }

    record ValidationResultArg(String sourceIndex, String defaultOwnerName, Map<String, String> typeToDefaultAccessLevel, List<SourceDoc> sourceDocs) {
    }

    record MigrationStats(String summary, Set<String> resourcesWithDefaultOwner, Set<String> skippedResourcesWitNoType) implements ToXContentObject
    {
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("summary", this.summary);
            builder.field("resourcesWithDefaultOwner", (Object)this.resourcesWithDefaultOwner.toArray(new String[0]));
            builder.array("skippedResources", this.skippedResourcesWitNoType.toArray(new String[0]));
            builder.endObject();
            return builder;
        }
    }
}

