/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.user;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.Strings;
import org.opensearch.security.privileges.PrivilegesConfiguration;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.TenantPrivileges;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.support.SecuritySettings;
import org.opensearch.security.support.SecurityUtils;

public class ThreadContextUserInfo {
    protected static final Logger log = LogManager.getLogger(ThreadContextUserInfo.class);
    private static final String READ_ACCESS = "READ";
    private static final String WRITE_ACCESS = "WRITE";
    private static final String NO_ACCESS = "NONE";
    private static final String GLOBAL_TENANT = "global_tenant";
    private volatile boolean userAttributeSerializationEnabled;
    private final ThreadContext threadContext;
    private final PrivilegesConfiguration privilegesConfiguration;

    public ThreadContextUserInfo(ThreadContext threadContext, PrivilegesConfiguration privilegesConfiguration, ClusterSettings clusterSettings, Settings settings) {
        this.threadContext = threadContext;
        this.userAttributeSerializationEnabled = settings.getAsBoolean("plugins.security.user_attribute_serialization.enabled", Boolean.valueOf(false));
        this.privilegesConfiguration = privilegesConfiguration;
        if (clusterSettings != null) {
            clusterSettings.addSettingsUpdateConsumer(SecuritySettings.USER_ATTRIBUTE_SERIALIZATION_ENABLED_SETTING, newIsUserAttributeSerializationEnabled -> {
                this.userAttributeSerializationEnabled = newIsUserAttributeSerializationEnabled;
            });
        }
    }

    public void setUserInfoInThreadContext(PrivilegesEvaluationContext context) {
        if (this.threadContext.getTransient("_opendistro_security_user_info") == null) {
            StringJoiner joiner = new StringJoiner("|");
            joiner.add(SecurityUtils.escapePipe(context.getUser().getName()));
            joiner.add(SecurityUtils.escapePipe(String.join((CharSequence)",", context.getUser().getRoles())));
            joiner.add(SecurityUtils.escapePipe(String.join((CharSequence)",", context.getMappedRoles())));
            String requestedTenant = context.getUser().getRequestedTenant();
            String tenant = Strings.isNullOrEmpty((String)requestedTenant) ? "" : requestedTenant;
            joiner.add(tenant);
            String tenantAccessToCheck = this.getTenancyAccess(context);
            joiner.add(tenantAccessToCheck);
            log.debug("userInfo: {}", (Object)joiner);
            if (this.userAttributeSerializationEnabled) {
                joiner.add(Base64Helper.serializeObject(new HashMap<String, String>((Map<String, String>)context.getUser().getCustomAttributesMap())));
            }
            this.threadContext.putTransient("_opendistro_security_user_info", (Object)joiner.toString());
        }
    }

    private String getTenancyAccess(PrivilegesEvaluationContext context) {
        String tenant;
        String requestedTenant = context.getUser().getRequestedTenant();
        TenantPrivileges tenantPrivileges = this.privilegesConfiguration.tenantPrivileges();
        String string = tenant = Strings.isNullOrEmpty((String)requestedTenant) ? GLOBAL_TENANT : requestedTenant;
        if (tenantPrivileges.hasTenantPrivilege(context, tenant, TenantPrivileges.ActionType.WRITE)) {
            return WRITE_ACCESS;
        }
        if (tenantPrivileges.hasTenantPrivilege(context, tenant, TenantPrivileges.ActionType.READ)) {
            return READ_ACCESS;
        }
        return NO_ACCESS;
    }
}

