/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;

public class BasicX509Credential
extends BasicCredential
implements X509Credential {
    @Nonnull
    private X509Certificate entityCert;
    @Nullable
    private Collection<X509Certificate> entityCertChain;
    @Nullable
    private Collection<X509CRL> crls;

    public BasicX509Credential(@Nonnull @ParameterName(name="entityCertificate") X509Certificate entityCertificate) {
        this.entityCert = Constraint.isNotNull(entityCertificate, "Credential certificate cannot be null");
    }

    public BasicX509Credential(@Nonnull @ParameterName(name="entityCertificate") X509Certificate entityCertificate, @ParameterName(name="privateKey") @Nonnull PrivateKey privateKey) {
        this.entityCert = Constraint.isNotNull(entityCertificate, "Credential certificate cannot be null");
        this.setPrivateKey(privateKey);
    }

    @Override
    @Nonnull
    public Class<? extends Credential> getCredentialType() {
        return X509Credential.class;
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Collection<X509CRL> getCRLs() {
        return this.crls;
    }

    public void setCRLs(@Nullable Collection<X509CRL> newCRLs) {
        this.crls = newCRLs != null ? CollectionSupport.copyToList(newCRLs) : CollectionSupport.emptyList();
    }

    @Override
    @Nonnull
    public X509Certificate getEntityCertificate() {
        return this.entityCert;
    }

    public void setEntityCertificate(@Nonnull X509Certificate newEntityCertificate) {
        Constraint.isNotNull(newEntityCertificate, "Credential certificate cannot be null");
        this.entityCert = newEntityCertificate;
    }

    @Override
    @Nullable
    public PublicKey getPublicKey() {
        return this.getEntityCertificate().getPublicKey();
    }

    @Override
    public void setPublicKey(@Nullable PublicKey newPublicKey) {
        throw new UnsupportedOperationException("Public key may not be set explicitly on an X509 credential");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<X509Certificate> getEntityCertificateChain() {
        BasicX509Credential basicX509Credential = this;
        synchronized (basicX509Credential) {
            if (this.entityCertChain != null) {
                return this.entityCertChain;
            }
            return CollectionSupport.singletonList(this.entityCert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntityCertificateChain(@Nonnull @NotEmpty Collection<X509Certificate> newCertificateChain) {
        Constraint.isNotNull(newCertificateChain, "Certificate chain collection cannot be null");
        Constraint.isNotEmpty(newCertificateChain, "Certificate chain collection cannot be empty");
        BasicX509Credential basicX509Credential = this;
        synchronized (basicX509Credential) {
            this.entityCertChain = CollectionSupport.copyToList(newCertificateChain);
        }
    }

    @Override
    @Nullable
    public SecretKey getSecretKey() {
        return null;
    }

    @Override
    public void setSecretKey(@Nullable SecretKey newSecretKey) {
        throw new UnsupportedOperationException("An X509Credential may not contain a secret key");
    }
}

