/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.soap.soap11.ActorBearing;
import org.opensaml.soap.soap11.MustUnderstandBearing;
import org.opensaml.soap.soap12.RelayBearing;
import org.opensaml.soap.soap12.RoleBearing;
import org.opensaml.soap.wssecurity.EncryptedHeader;
import org.opensaml.soap.wssecurity.IdBearing;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObject;
import org.opensaml.xmlsec.encryption.EncryptedData;

public class EncryptedHeaderImpl
extends AbstractWSSecurityObject
implements EncryptedHeader {
    @Nullable
    private EncryptedData encryptedData;
    @Nullable
    private String wsuId;
    @Nullable
    private XSBooleanValue soap11MustUnderstand;
    @Nullable
    private String soap11Actor;
    @Nullable
    private XSBooleanValue soap12MustUnderstand;
    @Nullable
    private String soap12Role;
    @Nullable
    private XSBooleanValue soap12Relay;

    public EncryptedHeaderImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public EncryptedData getEncryptedData() {
        return this.encryptedData;
    }

    @Override
    public void setEncryptedData(@Nullable EncryptedData newEncryptedData) {
        this.encryptedData = this.prepareForAssignment(this.encryptedData, newEncryptedData);
    }

    @Override
    @Nullable
    public String getWSUId() {
        return this.wsuId;
    }

    @Override
    public void setWSUId(@Nullable String newId) {
        String oldId = this.wsuId;
        this.wsuId = this.prepareForAssignment(this.wsuId, newId);
        this.registerOwnID(oldId, this.wsuId);
        this.manageQualifiedAttributeNamespace(IdBearing.WSU_ID_ATTR_NAME, this.wsuId != null);
    }

    @Override
    @Nullable
    public Boolean isSOAP11MustUnderstand() {
        if (this.soap11MustUnderstand != null) {
            return this.soap11MustUnderstand.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    @Nullable
    public XSBooleanValue isSOAP11MustUnderstandXSBoolean() {
        return this.soap11MustUnderstand;
    }

    @Override
    public void setSOAP11MustUnderstand(@Nullable Boolean newMustUnderstand) {
        this.soap11MustUnderstand = newMustUnderstand != null ? this.prepareForAssignment(this.soap11MustUnderstand, new XSBooleanValue(newMustUnderstand, true)) : (XSBooleanValue)this.prepareForAssignment(this.soap11MustUnderstand, null);
        this.manageQualifiedAttributeNamespace(MustUnderstandBearing.SOAP11_MUST_UNDERSTAND_ATTR_NAME, this.soap11MustUnderstand != null);
    }

    @Override
    public void setSOAP11MustUnderstand(@Nullable XSBooleanValue newMustUnderstand) {
        this.soap11MustUnderstand = this.prepareForAssignment(this.soap11MustUnderstand, newMustUnderstand);
        this.manageQualifiedAttributeNamespace(MustUnderstandBearing.SOAP11_MUST_UNDERSTAND_ATTR_NAME, this.soap11MustUnderstand != null);
    }

    @Override
    @Nullable
    public String getSOAP11Actor() {
        return this.soap11Actor;
    }

    @Override
    public void setSOAP11Actor(@Nullable String newActor) {
        this.soap11Actor = this.prepareForAssignment(this.soap11Actor, newActor);
        this.manageQualifiedAttributeNamespace(ActorBearing.SOAP11_ACTOR_ATTR_NAME, this.soap11Actor != null);
    }

    @Override
    @Nullable
    public Boolean isSOAP12MustUnderstand() {
        if (this.soap12MustUnderstand != null) {
            return this.soap12MustUnderstand.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    @Nullable
    public XSBooleanValue isSOAP12MustUnderstandXSBoolean() {
        return this.soap12MustUnderstand;
    }

    @Override
    public void setSOAP12MustUnderstand(@Nullable Boolean newMustUnderstand) {
        this.soap12MustUnderstand = newMustUnderstand != null ? this.prepareForAssignment(this.soap12MustUnderstand, new XSBooleanValue(newMustUnderstand, false)) : (XSBooleanValue)this.prepareForAssignment(this.soap12MustUnderstand, null);
        this.manageQualifiedAttributeNamespace(SOAP12_MUST_UNDERSTAND_ATTR_NAME, this.soap12MustUnderstand != null);
    }

    @Override
    public void setSOAP12MustUnderstand(@Nullable XSBooleanValue newMustUnderstand) {
        this.soap12MustUnderstand = this.prepareForAssignment(this.soap12MustUnderstand, newMustUnderstand);
        this.manageQualifiedAttributeNamespace(SOAP12_MUST_UNDERSTAND_ATTR_NAME, this.soap12MustUnderstand != null);
    }

    @Override
    @Nullable
    public String getSOAP12Role() {
        return this.soap12Role;
    }

    @Override
    public void setSOAP12Role(@Nullable String newRole) {
        this.soap12Role = this.prepareForAssignment(this.soap12Role, newRole);
        this.manageQualifiedAttributeNamespace(RoleBearing.SOAP12_ROLE_ATTR_NAME, this.soap12Role != null);
    }

    @Override
    @Nullable
    public Boolean isSOAP12Relay() {
        if (this.soap12Relay != null) {
            return this.soap12Relay.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    @Nullable
    public XSBooleanValue isSOAP12RelayXSBoolean() {
        return this.soap12Relay;
    }

    @Override
    public void setSOAP12Relay(@Nullable Boolean newRelay) {
        this.soap12Relay = newRelay != null ? this.prepareForAssignment(this.soap12Relay, new XSBooleanValue(newRelay, false)) : (XSBooleanValue)this.prepareForAssignment(this.soap12Relay, null);
        this.manageQualifiedAttributeNamespace(RelayBearing.SOAP12_RELAY_ATTR_NAME, this.soap12Relay != null);
    }

    @Override
    public void setSOAP12Relay(@Nullable XSBooleanValue newRelay) {
        this.soap12Relay = this.prepareForAssignment(this.soap12Relay, newRelay);
        this.manageQualifiedAttributeNamespace(RelayBearing.SOAP12_RELAY_ATTR_NAME, this.soap12Relay != null);
    }

    @Override
    @Nullable
    public List<XMLObject> getOrderedChildren() {
        if (this.encryptedData != null) {
            return CollectionSupport.singletonList(this.encryptedData);
        }
        return null;
    }
}

