﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/voice-id/VoiceID_EXPORTS.h>
#include <aws/voice-id/model/FailureDetails.h>
#include <aws/voice-id/model/JobProgress.h>
#include <aws/voice-id/model/SpeakerEnrollmentJobStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace VoiceID {
namespace Model {

/**
 * <p>Contains a summary of information about a speaker enrollment
 * job.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/SpeakerEnrollmentJobSummary">AWS
 * API Reference</a></p>
 */
class SpeakerEnrollmentJobSummary {
 public:
  AWS_VOICEID_API SpeakerEnrollmentJobSummary() = default;
  AWS_VOICEID_API SpeakerEnrollmentJobSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_VOICEID_API SpeakerEnrollmentJobSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_VOICEID_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A timestamp of when of the speaker enrollment job was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  SpeakerEnrollmentJobSummary& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the domain that contains the speaker enrollment job.</p>
   */
  inline const Aws::String& GetDomainId() const { return m_domainId; }
  inline bool DomainIdHasBeenSet() const { return m_domainIdHasBeenSet; }
  template <typename DomainIdT = Aws::String>
  void SetDomainId(DomainIdT&& value) {
    m_domainIdHasBeenSet = true;
    m_domainId = std::forward<DomainIdT>(value);
  }
  template <typename DomainIdT = Aws::String>
  SpeakerEnrollmentJobSummary& WithDomainId(DomainIdT&& value) {
    SetDomainId(std::forward<DomainIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A timestamp of when the speaker enrollment job ended.</p>
   */
  inline const Aws::Utils::DateTime& GetEndedAt() const { return m_endedAt; }
  inline bool EndedAtHasBeenSet() const { return m_endedAtHasBeenSet; }
  template <typename EndedAtT = Aws::Utils::DateTime>
  void SetEndedAt(EndedAtT&& value) {
    m_endedAtHasBeenSet = true;
    m_endedAt = std::forward<EndedAtT>(value);
  }
  template <typename EndedAtT = Aws::Utils::DateTime>
  SpeakerEnrollmentJobSummary& WithEndedAt(EndedAtT&& value) {
    SetEndedAt(std::forward<EndedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains details that are populated when an entire batch job fails. In cases
   * of individual registration job failures, the batch job as a whole doesn't fail;
   * it is completed with a <code>JobStatus</code> of
   * <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify
   * the individual registration requests that failed.</p>
   */
  inline const FailureDetails& GetFailureDetails() const { return m_failureDetails; }
  inline bool FailureDetailsHasBeenSet() const { return m_failureDetailsHasBeenSet; }
  template <typename FailureDetailsT = FailureDetails>
  void SetFailureDetails(FailureDetailsT&& value) {
    m_failureDetailsHasBeenSet = true;
    m_failureDetails = std::forward<FailureDetailsT>(value);
  }
  template <typename FailureDetailsT = FailureDetails>
  SpeakerEnrollmentJobSummary& WithFailureDetails(FailureDetailsT&& value) {
    SetFailureDetails(std::forward<FailureDetailsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The service-generated identifier for the speaker enrollment job.</p>
   */
  inline const Aws::String& GetJobId() const { return m_jobId; }
  inline bool JobIdHasBeenSet() const { return m_jobIdHasBeenSet; }
  template <typename JobIdT = Aws::String>
  void SetJobId(JobIdT&& value) {
    m_jobIdHasBeenSet = true;
    m_jobId = std::forward<JobIdT>(value);
  }
  template <typename JobIdT = Aws::String>
  SpeakerEnrollmentJobSummary& WithJobId(JobIdT&& value) {
    SetJobId(std::forward<JobIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The client-provided name for the speaker enrollment job.</p>
   */
  inline const Aws::String& GetJobName() const { return m_jobName; }
  inline bool JobNameHasBeenSet() const { return m_jobNameHasBeenSet; }
  template <typename JobNameT = Aws::String>
  void SetJobName(JobNameT&& value) {
    m_jobNameHasBeenSet = true;
    m_jobName = std::forward<JobNameT>(value);
  }
  template <typename JobNameT = Aws::String>
  SpeakerEnrollmentJobSummary& WithJobName(JobNameT&& value) {
    SetJobName(std::forward<JobNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Provides details regarding job progress. This field shows the completed
   * percentage of enrollment requests listed in the input file.</p>
   */
  inline const JobProgress& GetJobProgress() const { return m_jobProgress; }
  inline bool JobProgressHasBeenSet() const { return m_jobProgressHasBeenSet; }
  template <typename JobProgressT = JobProgress>
  void SetJobProgress(JobProgressT&& value) {
    m_jobProgressHasBeenSet = true;
    m_jobProgress = std::forward<JobProgressT>(value);
  }
  template <typename JobProgressT = JobProgress>
  SpeakerEnrollmentJobSummary& WithJobProgress(JobProgressT&& value) {
    SetJobProgress(std::forward<JobProgressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current status of the speaker enrollment job.</p>
   */
  inline SpeakerEnrollmentJobStatus GetJobStatus() const { return m_jobStatus; }
  inline bool JobStatusHasBeenSet() const { return m_jobStatusHasBeenSet; }
  inline void SetJobStatus(SpeakerEnrollmentJobStatus value) {
    m_jobStatusHasBeenSet = true;
    m_jobStatus = value;
  }
  inline SpeakerEnrollmentJobSummary& WithJobStatus(SpeakerEnrollmentJobStatus value) {
    SetJobStatus(value);
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_createdAt{};

  Aws::String m_domainId;

  Aws::Utils::DateTime m_endedAt{};

  FailureDetails m_failureDetails;

  Aws::String m_jobId;

  Aws::String m_jobName;

  JobProgress m_jobProgress;

  SpeakerEnrollmentJobStatus m_jobStatus{SpeakerEnrollmentJobStatus::NOT_SET};
  bool m_createdAtHasBeenSet = false;
  bool m_domainIdHasBeenSet = false;
  bool m_endedAtHasBeenSet = false;
  bool m_failureDetailsHasBeenSet = false;
  bool m_jobIdHasBeenSet = false;
  bool m_jobNameHasBeenSet = false;
  bool m_jobProgressHasBeenSet = false;
  bool m_jobStatusHasBeenSet = false;
};

}  // namespace Model
}  // namespace VoiceID
}  // namespace Aws
