/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.util.Arrays;
import org.a11y.brlapi.Component;
import org.a11y.brlapi.Parse;
import org.a11y.brlapi.SyntaxException;

public class WriteArguments
extends Component {
    private String text = null;
    private byte[] andMask = null;
    private byte[] orMask = null;
    private int regionBegin = 0;
    private int regionSize = 0;
    private int cursorPosition = -1;
    private int displayNumber = -1;
    public static final String TEXT = "text";
    public static final String AND_MASK = "and-mask";
    public static final String OR_MASK = "or-mask";
    public static final String REGION_BEGIN = "region begin";
    public static final String REGION_SIZE = "region size";
    public static final String CURSOR_POSITION = "cursor position";
    public static final String DISPLAY_NUMBER = "display number";

    public String getText() {
        return this.text;
    }

    public WriteArguments setText(String string) {
        this.text = string;
        return this;
    }

    public byte[] getAndMask() {
        return this.andMask;
    }

    public WriteArguments setAndMask(byte[] byArray) {
        this.andMask = byArray;
        return this;
    }

    public byte[] getOrMask() {
        return this.orMask;
    }

    public WriteArguments setOrMask(byte[] byArray) {
        this.orMask = byArray;
        return this;
    }

    public int getRegionBegin() {
        return this.regionBegin;
    }

    public WriteArguments setRegionBegin(int n) {
        this.regionBegin = n;
        return this;
    }

    public int getRegionSize() {
        return this.regionSize;
    }

    public WriteArguments setRegionSize(int n) {
        this.regionSize = n;
        return this;
    }

    public WriteArguments setRegion(int n, int n2) {
        this.setRegionBegin(n);
        this.setRegionSize(n2);
        return this;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public WriteArguments setCursorPosition(int n) {
        this.cursorPosition = n;
        return this;
    }

    public int getDisplayNumber() {
        return this.displayNumber;
    }

    public WriteArguments setDisplayNumber(int n) {
        this.displayNumber = n;
        return this;
    }

    private static void checkRange(String string, int n, Integer n2, Integer n3) {
        try {
            if (n2 != null) {
                Parse.checkMinimum(string, n, n2.intValue());
            }
            if (n3 != null) {
                Parse.checkMaximum(string, n, n3.intValue());
            }
        }
        catch (SyntaxException syntaxException) {
            throw new IllegalStateException(syntaxException.getMessage());
        }
    }

    public final void check(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = this.regionBegin != 0;
        boolean bl4 = this.regionSize != 0;
        boolean bl5 = bl3 || bl4;
        boolean bl6 = this.text != null;
        boolean bl7 = this.andMask != null;
        boolean bl8 = this.orMask != null;
        boolean bl9 = bl2 = bl6 || bl7 || bl8;
        if (bl5 || bl2) {
            Object object;
            if (!bl2) {
                throw new IllegalStateException(String.format("region content (%s, %s, and/or %s) not specified", TEXT, AND_MASK, OR_MASK));
            }
            if (!bl3) {
                if (!bl) {
                    throw new IllegalStateException(String.format("%s not set", REGION_BEGIN));
                }
                this.regionBegin = 1;
                bl3 = true;
                bl5 = true;
            }
            if (!bl4) {
                if (!bl) {
                    throw new IllegalStateException(String.format("%s not set", REGION_SIZE));
                }
                this.regionSize = 0;
                if (bl6) {
                    this.regionSize = Math.max(this.regionSize, this.text.length());
                }
                if (bl7) {
                    this.regionSize = Math.max(this.regionSize, this.andMask.length);
                }
                if (bl8) {
                    this.regionSize = Math.max(this.regionSize, this.orMask.length);
                }
                bl4 = true;
                bl5 = true;
            }
            WriteArguments.checkRange(REGION_BEGIN, this.regionBegin, 1, n);
            WriteArguments.checkRange(REGION_SIZE, this.regionSize, 1, null);
            int n2 = n + 1 - this.regionBegin;
            if (!bl) {
                WriteArguments.checkRange(REGION_SIZE, this.regionSize, null, n2);
            } else if (this.regionSize > n2) {
                this.regionSize = n2;
            }
            if (bl6) {
                n2 = this.text.length();
                if (n2 > this.regionSize) {
                    if (!bl) {
                        throw new IllegalStateException(String.format("%s length is greater than %s: %d > %d", TEXT, REGION_SIZE, n2, this.regionSize));
                    }
                    this.text = this.text.substring(0, this.regionSize);
                } else if (n2 < this.regionSize) {
                    if (!bl) {
                        throw new IllegalStateException(String.format("%s length is less than %s: %d < %d", TEXT, REGION_SIZE, n2, this.regionSize));
                    }
                    object = new StringBuilder(this.text);
                    while (((StringBuilder)object).length() < this.regionSize) {
                        ((StringBuilder)object).append(' ');
                    }
                    this.text = ((StringBuilder)object).toString();
                }
            }
            if (bl7) {
                n2 = this.andMask.length;
                if (n2 > this.regionSize) {
                    if (!bl) {
                        throw new IllegalStateException(String.format("%s size is greater than %s: %d > %d", AND_MASK, REGION_SIZE, n2, this.regionSize));
                    }
                    object = new byte[this.regionSize];
                    System.arraycopy(this.andMask, 0, object, 0, this.regionSize);
                    this.andMask = object;
                } else if (n2 < this.regionSize) {
                    if (!bl) {
                        throw new IllegalStateException(String.format("%s size is less than %s: %d < %d", AND_MASK, REGION_SIZE, n2, this.regionSize));
                    }
                    object = new byte[this.regionSize];
                    System.arraycopy(this.andMask, 0, object, 0, n2);
                    Arrays.fill((byte[])object, n2, this.regionSize - n2, (byte)-1);
                    this.andMask = (byte[])object;
                }
            }
            if (bl8) {
                n2 = this.orMask.length;
                if (n2 > this.regionSize) {
                    if (!bl) {
                        throw new IllegalStateException(String.format("%s size is greater than %s: %d > %d", OR_MASK, REGION_SIZE, n2, this.regionSize));
                    }
                    object = new byte[this.regionSize];
                    System.arraycopy(this.orMask, 0, object, 0, this.regionSize);
                    this.orMask = (byte[])object;
                } else if (n2 < this.regionSize) {
                    if (!bl) {
                        throw new IllegalStateException(String.format("%s size is less than %s: %d < %d", OR_MASK, REGION_SIZE, n2, this.regionSize));
                    }
                    object = new byte[this.regionSize];
                    System.arraycopy(this.orMask, 0, object, 0, n2);
                    Arrays.fill((byte[])object, n2, this.regionSize - n2, (byte)0);
                    this.orMask = (byte[])object;
                }
            }
        }
        if (this.cursorPosition != 0 && this.cursorPosition != -1) {
            WriteArguments.checkRange(CURSOR_POSITION, this.cursorPosition, 1, n);
        }
    }
}

