/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import net.sf.mpxj.Filter;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.reader.UniversalProjectReader;

public class MpxjFilter {
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: MpxFilter <input file name> <filter name>");
            } else {
                MpxjFilter.filter(args[0], args[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static void filter(String filename, String filtername) throws Exception {
        ProjectFile project = new UniversalProjectReader().read(filename);
        Filter filter = project.getFilters().getFilterByName(filtername);
        if (filter == null) {
            MpxjFilter.displayAvailableFilters(project);
        } else {
            System.out.println(filter);
            System.out.println();
            if (filter.isTaskFilter()) {
                MpxjFilter.processTaskFilter(project, filter);
            } else {
                MpxjFilter.processResourceFilter(project, filter);
            }
        }
    }

    private static void displayAvailableFilters(ProjectFile project) {
        System.out.println("Unknown filter name supplied.");
        System.out.println("Available task filters:");
        for (Filter filter : project.getFilters().getTaskFilters()) {
            System.out.println("   " + filter.getName());
        }
        System.out.println("Available resource filters:");
        for (Filter filter : project.getFilters().getResourceFilters()) {
            System.out.println("   " + filter.getName());
        }
    }

    private static void processTaskFilter(ProjectFile project, Filter filter) {
        for (Task task : project.getTasks()) {
            if (!filter.evaluate(task, null)) continue;
            System.out.println(task.getID() + "," + task.getUniqueID() + "," + task.getName());
        }
    }

    private static void processResourceFilter(ProjectFile project, Filter filter) {
        for (Resource resource : project.getResources()) {
            if (!filter.evaluate(resource, null)) continue;
            System.out.println(resource.getID() + "," + resource.getUniqueID() + "," + resource.getName());
        }
    }
}

