/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.ViewIntroAdapterPart;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityView;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.intro.IntroMessages;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IntroContentDetector;

public class WorkbenchIntroManager
implements IIntroManager {
    private final Workbench workbench;
    private IIntroPart introPart;

    WorkbenchIntroManager(Workbench workbench) {
        this.workbench = workbench;
        workbench.getExtensionTracker().registerHandler(new IExtensionChangeHandler(){

            public void addExtension(IExtensionTracker tracker, IExtension extension) {
            }

            public void removeExtension(IExtension source, Object[] objects) {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IIntroPart) {
                        WorkbenchIntroManager.this.closeIntro((IIntroPart)object);
                    }
                    ++n2;
                }
            }
        }, null);
    }

    @Override
    public boolean closeIntro(IIntroPart part) {
        if (this.introPart == null || !this.introPart.equals(part)) {
            return false;
        }
        ViewIntroAdapterPart introView = this.getViewIntroAdapterPart();
        if (introView != null) {
            IWorkbenchPage page = introView.getSite().getPage();
            if (page == null) {
                this.introPart = null;
                return true;
            }
            IViewReference reference = page.findViewReference("org.eclipse.ui.internal.introview");
            page.hideView(introView);
            if (reference == null || reference.getPart(false) == null) {
                this.introPart = null;
                return true;
            }
            return false;
        }
        this.introPart = null;
        return true;
    }

    @Override
    public IIntroPart showIntro(IWorkbenchWindow preferredWindow, boolean standby) {
        if (preferredWindow == null) {
            preferredWindow = this.workbench.getActiveWorkbenchWindow();
        }
        if (preferredWindow == null) {
            return null;
        }
        ViewIntroAdapterPart viewPart = this.getViewIntroAdapterPart();
        if (viewPart == null) {
            this.createIntro(preferredWindow);
        } else {
            try {
                IWorkbenchPage page = viewPart.getSite().getPage();
                IWorkbenchWindow window = page.getWorkbenchWindow();
                if (!window.equals(preferredWindow)) {
                    window.getShell().setActive();
                }
                page.showView("org.eclipse.ui.internal.introview");
            }
            catch (PartInitException e) {
                WorkbenchPlugin.log("Could not open intro", (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "Could not open intro", (Throwable)((Object)e)));
            }
        }
        this.setIntroStandby(this.introPart, standby);
        return this.introPart;
    }

    boolean isIntroInWindow(IWorkbenchWindow testWindow) {
        ViewIntroAdapterPart viewPart = this.getViewIntroAdapterPart();
        if (viewPart == null) {
            return false;
        }
        IWorkbenchWindow window = viewPart.getSite().getWorkbenchWindow();
        return window.equals(testWindow);
    }

    private void createIntro(IWorkbenchWindow preferredWindow) {
        if (this.workbench.getIntroDescriptor() == null) {
            return;
        }
        IWorkbenchPage workbenchPage = preferredWindow.getActivePage();
        if (workbenchPage == null) {
            return;
        }
        try {
            workbenchPage.showView("org.eclipse.ui.internal.introview");
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log(IntroMessages.Intro_could_not_create_part, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, IntroMessages.Intro_could_not_create_part, (Throwable)((Object)e)));
        }
    }

    @Override
    public void setIntroStandby(IIntroPart part, boolean standby) {
        if (this.introPart == null || !this.introPart.equals(part)) {
            return;
        }
        ViewIntroAdapterPart viewIntroAdapterPart = this.getViewIntroAdapterPart();
        if (viewIntroAdapterPart == null) {
            return;
        }
        MPartStack introStack = this.getIntroStack(viewIntroAdapterPart);
        if (introStack == null) {
            return;
        }
        boolean isMaximized = this.isIntroMaximized(viewIntroAdapterPart);
        if (!isMaximized && !standby) {
            introStack.getTags().add("Maximized");
        } else if (isMaximized && standby) {
            introStack.getTags().remove("Maximized");
        }
    }

    private MPartStack getIntroStack(ViewIntroAdapterPart introAdapter) {
        MElementContainer introPartParent;
        ViewSite site = (ViewSite)introAdapter.getViewSite();
        MPart introModelPart = site.getModel();
        if (introModelPart.getCurSharedRef() != null && (introPartParent = introModelPart.getCurSharedRef().getParent()) instanceof MPartStack) {
            return (MPartStack)introPartParent;
        }
        return null;
    }

    private boolean isIntroMaximized(ViewIntroAdapterPart introAdapter) {
        MPartStack introStack = this.getIntroStack(introAdapter);
        if (introStack == null) {
            return false;
        }
        return introStack.getTags().contains("Maximized");
    }

    @Override
    public boolean isIntroStandby(IIntroPart part) {
        if (this.introPart == null || !this.introPart.equals(part)) {
            return false;
        }
        ViewIntroAdapterPart viewIntroAdapterPart = this.getViewIntroAdapterPart();
        if (viewIntroAdapterPart == null) {
            return false;
        }
        return !this.isIntroMaximized(viewIntroAdapterPart);
    }

    @Override
    public IIntroPart getIntro() {
        return this.introPart;
    }

    ViewIntroAdapterPart getViewIntroAdapterPart() {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPart obj;
            MPlaceholder introPH;
            MPart introModelPart;
            CompatibilityView compatView;
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
            WorkbenchWindow window = (WorkbenchWindow)iWorkbenchWindow;
            MUIElement introPart = window.modelService.find("org.eclipse.ui.internal.introview", (MUIElement)window.getModel());
            if (introPart instanceof MPlaceholder && (compatView = (CompatibilityView)(introModelPart = (MPart)(introPH = (MPlaceholder)introPart).getRef()).getObject()) != null && (obj = compatView.getPart()) instanceof ViewIntroAdapterPart) {
                return (ViewIntroAdapterPart)obj;
            }
            ++n2;
        }
        return null;
    }

    IIntroPart createNewIntroPart() throws CoreException {
        IntroDescriptor introDescriptor = this.workbench.getIntroDescriptor();
        IIntroPart iIntroPart = this.introPart = introDescriptor == null ? null : introDescriptor.createIntro();
        if (this.introPart != null) {
            this.workbench.getExtensionTracker().registerObject(introDescriptor.getConfigurationElement().getDeclaringExtension(), (Object)this.introPart, 2);
        }
        return this.introPart;
    }

    @Override
    public boolean hasIntro() {
        return this.workbench.getIntroDescriptor() != null;
    }

    @Override
    public boolean isNewContentAvailable() {
        IntroDescriptor introDescriptor = this.workbench.getIntroDescriptor();
        if (introDescriptor == null) {
            return false;
        }
        try {
            IntroContentDetector contentDetector = introDescriptor.getIntroContentDetector();
            if (contentDetector != null) {
                return contentDetector.isNewContentAvailable();
            }
        }
        catch (CoreException ex) {
            WorkbenchPlugin.log((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, 2, "Could not load intro content detector", (Throwable)ex));
        }
        return false;
    }
}

