/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.templates;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.text.templates.TemplateReaderWriter;
import org.osgi.service.prefs.BackingStoreException;

public class TemplateStoreCore {
    private final List<TemplatePersistenceData> fTemplates = new ArrayList<TemplatePersistenceData>();
    private final IEclipsePreferences fPreferenceStore;
    private final String fKey;
    private ContextTypeRegistry fRegistry;
    private boolean fIgnorePreferenceStoreChanges = false;
    private IEclipsePreferences.IPreferenceChangeListener fPropertyListener;

    public TemplateStoreCore(IEclipsePreferences store, String key) {
        Assert.isNotNull((Object)key);
        this.fPreferenceStore = store;
        this.fKey = key;
    }

    public TemplateStoreCore(ContextTypeRegistry registry, IEclipsePreferences store, String key) {
        this(store, key);
        this.fRegistry = registry;
    }

    public void load() throws IOException {
        this.fTemplates.clear();
        this.loadContributedTemplates();
        this.loadCustomTemplates();
    }

    public void startListeningForPreferenceChanges() {
        if (this.fPropertyListener == null) {
            this.fPropertyListener = event -> {
                if (!this.fIgnorePreferenceStoreChanges && this.fKey.equals(event.getKey())) {
                    try {
                        this.load();
                    }
                    catch (IOException x) {
                        this.handleException(x);
                    }
                }
            };
            this.fPreferenceStore.addPreferenceChangeListener(this.fPropertyListener);
        }
    }

    public void stopListeningForPreferenceChanges() {
        if (this.fPropertyListener != null) {
            this.fPreferenceStore.removePreferenceChangeListener(this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    protected void handleException(IOException x) {
        x.printStackTrace();
    }

    protected void loadContributedTemplates() throws IOException {
    }

    protected void internalAdd(TemplatePersistenceData data) {
        if (!data.isCustom()) {
            String id = data.getId();
            for (TemplatePersistenceData persistenceData : this.fTemplates) {
                if (persistenceData.getId() == null || !persistenceData.getId().equals(id)) continue;
                return;
            }
            this.fTemplates.add(data);
        }
    }

    public void save() throws IOException {
        ArrayList<TemplatePersistenceData> custom = new ArrayList<TemplatePersistenceData>();
        for (TemplatePersistenceData data : this.fTemplates) {
            if (!data.isCustom() || data.isUserAdded() && data.isDeleted()) continue;
            custom.add(data);
        }
        StringWriter output = new StringWriter();
        TemplateReaderWriter writer = new TemplateReaderWriter();
        writer.save(custom.toArray(new TemplatePersistenceData[custom.size()]), output);
        this.fIgnorePreferenceStoreChanges = true;
        try {
            try {
                this.fPreferenceStore.put(this.fKey, output.toString());
                this.fPreferenceStore.flush();
            }
            catch (BackingStoreException backingStoreException) {
                this.fIgnorePreferenceStoreChanges = false;
            }
        }
        finally {
            this.fIgnorePreferenceStoreChanges = false;
        }
    }

    public void add(TemplatePersistenceData data) {
        if (!this.validateTemplate(data.getTemplate())) {
            return;
        }
        if (data.isUserAdded()) {
            this.fTemplates.add(data);
        } else {
            for (TemplatePersistenceData persistenceData : this.fTemplates) {
                if (persistenceData.getId() == null || !persistenceData.getId().equals(data.getId())) continue;
                persistenceData.setTemplate(data.getTemplate());
                persistenceData.setDeleted(data.isDeleted());
                persistenceData.setEnabled(data.isEnabled());
                return;
            }
            if (data.getTemplate() != null) {
                TemplatePersistenceData newData = new TemplatePersistenceData(data.getTemplate(), data.isEnabled(), data.getId());
                this.fTemplates.add(newData);
            }
        }
    }

    public void delete(TemplatePersistenceData data) {
        if (data.isUserAdded()) {
            this.fTemplates.remove(data);
        } else {
            data.setDeleted(true);
        }
    }

    public void restoreDeleted() {
        for (TemplatePersistenceData data : this.fTemplates) {
            if (!data.isDeleted()) continue;
            data.setDeleted(false);
        }
    }

    public void restoreDefaults(boolean doSave) {
        String oldValue = null;
        if (!doSave) {
            oldValue = this.fPreferenceStore.get(this.fKey, null);
        }
        try {
            this.fIgnorePreferenceStoreChanges = true;
            this.fPreferenceStore.put(this.fKey, "");
        }
        finally {
            this.fIgnorePreferenceStoreChanges = false;
        }
        try {
            this.load();
        }
        catch (IOException x) {
            this.handleException(x);
        }
        if (oldValue != null) {
            try {
                this.fIgnorePreferenceStoreChanges = true;
                this.fPreferenceStore.put(this.fKey, oldValue);
            }
            finally {
                this.fIgnorePreferenceStoreChanges = false;
            }
        }
    }

    public void restoreDefaults() {
        this.restoreDefaults(true);
    }

    public Template[] getTemplates() {
        return this.getTemplates(null);
    }

    public Template[] getTemplates(String contextTypeId) {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (TemplatePersistenceData data : this.fTemplates) {
            if (!data.isEnabled() || data.isDeleted() || contextTypeId != null && !contextTypeId.equals(data.getTemplate().getContextTypeId())) continue;
            templates.add(data.getTemplate());
        }
        return templates.toArray(new Template[templates.size()]);
    }

    public Template findTemplate(String name) {
        return this.findTemplate(name, null);
    }

    public Template findTemplate(String name, String contextTypeId) {
        Assert.isNotNull((Object)name);
        for (TemplatePersistenceData data : this.fTemplates) {
            Template template = data.getTemplate();
            if (!data.isEnabled() || data.isDeleted() || contextTypeId != null && !contextTypeId.equals(template.getContextTypeId()) || !name.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    public Template findTemplateById(String id) {
        TemplatePersistenceData data = this.getTemplateData(id);
        if (data != null && !data.isDeleted()) {
            return data.getTemplate();
        }
        return null;
    }

    public TemplatePersistenceData[] getTemplateData(boolean includeDeleted) {
        ArrayList<TemplatePersistenceData> datas = new ArrayList<TemplatePersistenceData>();
        for (TemplatePersistenceData data : this.fTemplates) {
            if (!includeDeleted && data.isDeleted()) continue;
            datas.add(data);
        }
        return datas.toArray(new TemplatePersistenceData[datas.size()]);
    }

    public TemplatePersistenceData getTemplateData(String id) {
        Assert.isNotNull((Object)id);
        for (TemplatePersistenceData data : this.fTemplates) {
            if (!id.equals(data.getId())) continue;
            return data;
        }
        return null;
    }

    private void loadCustomTemplates() throws IOException {
        String pref = this.fPreferenceStore.get(this.fKey, null);
        if (pref != null && !pref.trim().isEmpty()) {
            TemplatePersistenceData[] datas;
            StringReader input = new StringReader(pref);
            TemplateReaderWriter reader = new TemplateReaderWriter();
            TemplatePersistenceData[] templatePersistenceDataArray = datas = reader.read(input);
            int n = datas.length;
            int n2 = 0;
            while (n2 < n) {
                TemplatePersistenceData data = templatePersistenceDataArray[n2];
                this.add(data);
                ++n2;
            }
        }
    }

    private boolean validateTemplate(Template template) {
        String contextTypeId = template.getContextTypeId();
        if (this.contextExists(contextTypeId)) {
            if (this.fRegistry != null) {
                try {
                    this.fRegistry.getContextType(contextTypeId).validate(template.getPattern());
                }
                catch (TemplateException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean contextExists(String contextTypeId) {
        return contextTypeId != null && (this.fRegistry == null || this.fRegistry.getContextType(contextTypeId) != null);
    }

    protected ContextTypeRegistry getRegistry() {
        return this.fRegistry;
    }

    protected final String getKey() {
        return this.fKey;
    }

    protected final List<TemplatePersistenceData> internalGetTemplates() {
        return this.fTemplates;
    }
}

