/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBAbstractUser;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBPrivilege;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.access.DBAPrivilegeGrant;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class IoTDBGrant
implements DBSObject,
DBAPrivilegeGrant {
    private final IoTDBAbstractUser user;
    private final List<IoTDBPrivilege> privileges;
    private String role;
    private String scope;
    private Boolean grantOption;

    public IoTDBGrant(IoTDBAbstractUser user, List<IoTDBPrivilege> privileges, String role, String scope, boolean grantOption) {
        this.user = user;
        this.privileges = privileges;
        this.role = role;
        this.scope = scope;
        this.grantOption = grantOption;
    }

    public Object getSubject(@NotNull DBRProgressMonitor dbrProgressMonitor) throws DBException {
        return this.user;
    }

    public Object getObject(@NotNull DBRProgressMonitor dbrProgressMonitor) throws DBException {
        return "testObject";
    }

    public DBAPrivilege[] getPrivileges() {
        return this.privileges.toArray(new DBAPrivilege[0]);
    }

    public boolean isGranted() {
        return this.grantOption;
    }

    public DBSObject getParentObject() {
        return this.user;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.user.getDataSource();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.privileges.get((int)0).name;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, order=2)
    @Nullable
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Property(viewable=true, order=3)
    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Property(viewable=true, editable=true, order=4)
    public Boolean getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(Boolean grantOption) {
        this.grantOption = grantOption;
    }

    public boolean matches(String db, String tb) {
        return this.scope.equals("*.*") || this.scope.equals(db + "." + tb) || this.scope.equals(db + ".*");
    }

    public boolean canHighlightDatabase(String db) {
        return this.scope.startsWith("*.") || this.scope.startsWith(db + ".");
    }

    public boolean canHighlightTable(String db, String tb) {
        return this.scope.startsWith("*.") || this.scope.equals(db + ".*") || this.scope.equals(db + "." + tb);
    }
}

