/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.fop.afp.Streamable;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;

public class ResourceGroup
extends AbstractNamedAFPObject {
    private final Set<AbstractNamedAFPObject> resourceSet = new HashSet<AbstractNamedAFPObject>();

    public ResourceGroup(String name) {
        super(name);
    }

    public void addObject(AbstractNamedAFPObject namedObject) throws IOException {
        this.resourceSet.add(namedObject);
    }

    public int getResourceCount() {
        return this.resourceSet.size();
    }

    @Override
    public void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        this.copySF(data, (byte)-88, (byte)-58);
        os.write(data);
    }

    @Override
    public void writeContent(OutputStream os) throws IOException {
        for (AbstractNamedAFPObject object : this.resourceSet) {
            if (!(object instanceof Streamable)) continue;
            Streamable streamableObject = object;
            streamableObject.writeToStream(os);
        }
    }

    @Override
    public void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        this.copySF(data, (byte)-87, (byte)-58);
        os.write(data);
    }

    @Override
    public String toString() {
        return this.name + " " + this.resourceSet;
    }
}

