/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.WinFlatEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.WinFlatUtils;

public class WinFlatEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final int ICON_X_PAD = 4;
    private final Color background = UIManager.getColor("EditorTab.background");
    private final Color activeBackground = WinFlatUtils.Utils.getUIColor("EditorTab.activeBackground", this.background);
    private final Color contentBorderColor = UIManager.getColor("TabbedContainer.editor.contentBorderColor");
    private final boolean unscaledBorders = WinFlatUtils.Utils.getUIBoolean("EditorTab.unscaledBorders", false);
    private final Insets tabInsets = WinFlatUtils.UIScale.scale(UIManager.getInsets("EditorTab.tabInsets"));

    public WinFlatEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinFlatEditorTabDisplayerUI((TabDisplayer)c);
    }

    @Override
    protected TabCellRenderer createDefaultRenderer() {
        return new WinFlatEditorTabCellRenderer();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int prefHeight;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = fm.getHeight() + ins.top + ins.bottom + this.tabInsets.top + this.tabInsets.bottom;
        } else {
            prefHeight = WinFlatUtils.UIScale.scale(28);
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    @Override
    public TabCellRenderer getTabCellRenderer(int tab) {
        TabCellRenderer ren = super.getTabCellRenderer(tab);
        if (ren instanceof WinFlatEditorTabCellRenderer) {
            WinFlatEditorTabCellRenderer fren = (WinFlatEditorTabCellRenderer)ren;
            int N = this.displayer.getModel().size();
            fren.firstTab = tab == 0;
            fren.lastTab = tab == N - 1;
            fren.nextTabSelected = tab + 1 < N && (this.tabState.getState(tab + 1) & 0x10) != 0;
        }
        return ren;
    }

    @Override
    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, this.getControlButtons().getPreferredSize().width + 4);
    }

    @Override
    protected Rectangle getControlButtonsRectangle(Container parent) {
        Component c = this.getControlButtons();
        return new Rectangle(parent.getWidth() - c.getWidth() - 4, (parent.getHeight() - c.getHeight()) / 2, c.getWidth(), c.getHeight());
    }

    @Override
    public void paintBackground(Graphics g) {
        int width = this.displayer.getWidth();
        int height = this.displayer.getHeight();
        WinFlatUtils.HiDPIUtils.paintAtScale1x(g, 0, 0, width, height, this::paintBackgroundAtScale1x);
    }

    private void paintBackgroundAtScale1x(Graphics2D g, int width, int height, double scale) {
        g.setColor(this.displayer.isActive() ? this.activeBackground : this.background);
        g.fillRect(0, 0, width, height);
        int contentBorderWidth = this.unscaledBorders ? 1 : WinFlatUtils.HiDPIUtils.deviceBorderWidth(scale, 1);
        g.setColor(this.contentBorderColor);
        g.fillRect(0, height - contentBorderWidth, width, contentBorderWidth);
    }

    @Override
    public Icon getButtonIcon(int buttonId, int buttonState) {
        Icon ret = WinFlatUtils.FlatTabControlIcon.get(buttonId, buttonState);
        return ret != null ? ret : super.getButtonIcon(buttonId, buttonState);
    }
}

