/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.TimeAttributeIterable;

public class AttributesImpl {
    protected Object[] attributes;

    public AttributesImpl(ColumnStore columnStore) {
        if (columnStore != null) {
            int length = columnStore.length;
            ColumnImpl[] cols = columnStore.columns;
            this.attributes = new Object[length];
            for (int i = 0; i < length; ++i) {
                ColumnImpl c = cols[i];
                if (c == null || c.isProperty()) continue;
                this.attributes[i] = c.getDefaultValue();
            }
        } else {
            this.attributes = new Object[4];
        }
    }

    public Object getId() {
        return this.attributes[0];
    }

    public void setId(Object id) {
        this.attributes[0] = id;
    }

    public String getLabel() {
        if (this.attributes.length > 1) {
            return (String)this.attributes[1];
        }
        return null;
    }

    public Object getAttribute(Column column) {
        return this.getAttribute(column.getIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(int index) {
        Object res = null;
        AttributesImpl attributesImpl = this;
        synchronized (attributesImpl) {
            if (index < this.attributes.length) {
                res = this.attributes[index];
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAttribute(Column column, Object timeObject, Estimator estimator) {
        int index = column.getIndex();
        AttributesImpl attributesImpl = this;
        synchronized (attributesImpl) {
            Object dynamicValue = null;
            if (index < this.attributes.length) {
                dynamicValue = this.attributes[index];
            }
            if (TimeSet.class.isAssignableFrom(column.getTypeClass())) {
                return dynamicValue;
            }
            TimeMap timeMap = (TimeMap)dynamicValue;
            if (timeMap != null && !timeMap.isEmpty()) {
                if (estimator == null) {
                    return timeMap.get(timeObject, column.getDefaultValue());
                }
                return timeMap.get((Interval)timeObject, estimator);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeTimeAttribute(Column column, Object timeObject) {
        int index = column.getIndex();
        Object oldValue = null;
        boolean res = false;
        AttributesImpl attributesImpl = this;
        synchronized (attributesImpl) {
            TimeMap dynamicValue = (TimeMap)this.attributes[index];
            if (dynamicValue != null) {
                oldValue = dynamicValue.get(timeObject, null);
                res = dynamicValue.remove(timeObject);
            }
        }
        return oldValue;
    }

    protected Object setAttribute(Column column, Object value) {
        int index = column.getIndex();
        return this.setAttribute(index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttribute(int index, Object value) {
        Object oldValue = null;
        AttributesImpl attributesImpl = this;
        synchronized (attributesImpl) {
            if (index >= this.attributes.length) {
                Object[] newArray = new Object[index + 1];
                System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
                this.attributes = newArray;
            } else {
                oldValue = this.attributes[index];
            }
            this.attributes[index] = value;
        }
        return oldValue;
    }

    private Object ensureSize(int index) {
        if (index < this.attributes.length) {
            return this.attributes[index];
        }
        Object[] newArray = new Object[index + 1];
        System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
        this.attributes = newArray;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object setAttribute(Column column, Object value, Object timeObject) {
        int index = column.getIndex();
        Object oldValue = null;
        AttributesImpl attributesImpl = this;
        synchronized (attributesImpl) {
            TimeMap dynamicValue;
            oldValue = this.ensureSize(index);
            if (oldValue == null) {
                try {
                    dynamicValue = (TimeMap)column.getTypeClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.attributes[index] = dynamicValue;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                dynamicValue = (TimeMap)oldValue;
            }
            dynamicValue.put(timeObject, value);
            return dynamicValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addTime(Object timeObject) {
        boolean res;
        AttributesImpl attributesImpl = this;
        synchronized (attributesImpl) {
            TimeSet<Interval> timeSet = this.getTimeSet();
            if (timeSet == null) {
                timeSet = timeObject instanceof Interval ? new IntervalSet() : new TimestampSet();
                int index = 2;
                if (index >= this.attributes.length) {
                    Object[] newArray = new Object[index + 1];
                    System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
                    this.attributes = newArray;
                }
                this.attributes[index] = timeSet;
            }
            res = timeSet.add((Interval)timeObject);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeTime(Object timeObject) {
        boolean res = false;
        AttributesImpl attributesImpl = this;
        synchronized (attributesImpl) {
            TimeSet timeSet = this.getTimeSet();
            if (timeSet != null) {
                res = timeSet.remove(timeObject);
            }
        }
        return res;
    }

    protected TimeSet getTimeSet() {
        if (2 < this.attributes.length) {
            return (TimeSet)this.attributes[2];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasTime(Object timeObject) {
        AttributesImpl attributesImpl = this;
        synchronized (attributesImpl) {
            TimeSet timeSet = this.getTimeSet();
            if (timeSet != null) {
                return timeSet.contains(timeObject);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<Map.Entry> getAttributes(Column column) {
        int index = column.getIndex();
        TimeMap dynamicValue = null;
        AttributesImpl attributesImpl = this;
        synchronized (attributesImpl) {
            if (index < this.attributes.length) {
                dynamicValue = (TimeMap)this.attributes[index];
            }
            if (dynamicValue != null) {
                Object[] values = dynamicValue.toValuesArray();
                if (dynamicValue instanceof TimestampMap) {
                    return new TimeAttributeIterable(((TimestampMap)dynamicValue).getTimestamps(), values);
                }
                if (dynamicValue instanceof IntervalMap) {
                    return new TimeAttributeIterable(((IntervalMap)dynamicValue).toKeysArray(), values);
                }
            }
        }
        return TimeAttributeIterable.EMPTY_ITERABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getTimeSetArray() {
        AttributesImpl attributesImpl = this;
        synchronized (attributesImpl) {
            TimeSet timeSet = this.getTimeSet();
            if (timeSet != null) {
                return timeSet.toPrimitiveArray();
            }
        }
        return null;
    }

    public Object[] getBackingArray() {
        return this.attributes;
    }

    protected void setBackingArray(Object[] attributes) {
        this.attributes = attributes;
    }
}

