/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffSectionMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DirectSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class PeCoffSectionSymbolApplier
extends MsSymbolApplier
implements DirectSymbolApplier {
    private PeCoffSectionMsSymbol symbol;

    public PeCoffSectionSymbolApplier(DefaultPdbApplicator applicator, PeCoffSectionMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void apply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        int sectionNum = this.symbol.getSectionNumber();
        long realAddress = this.symbol.getRva();
        this.symbol.getLength();
        this.symbol.getCharacteristics();
        this.symbol.getAlign();
        this.symbol.getName();
    }

    private PeCoffSectionMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof PeCoffSectionMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        PeCoffSectionMsSymbol peCoffSectionSymbol = (PeCoffSectionMsSymbol)abstractSymbol;
        return peCoffSectionSymbol;
    }
}

