/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import ghidra.framework.preferences.Preferences;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.net.PKIUtils;
import ghidra.net.SignedToken;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.StringUtils;

public class DefaultKeyManagerFactory {
    public static final String KEYSTORE_PATH_PROPERTY = "ghidra.keystore";
    public static final String KEYSTORE_PASSWORD_PROPERTY = "ghidra.password";
    public static final String DEFAULT_PASSWORD = "changeme";
    private static final int SELF_SIGNED_DURATION_DAYS = 730;
    private static X500Principal defaultIdentity;
    private static List<String> defaultSubjectAlternativeNames;
    private static final DefaultX509KeyManager keyManagerWrapper;

    private static String prunePath(String path) {
        if (path != null && (path = path.trim()).length() == 0) {
            path = null;
        }
        return path;
    }

    public static synchronized boolean setDefaultKeyStore(String path, boolean savePreference) {
        if (System.getProperty(KEYSTORE_PATH_PROPERTY) != null) {
            Msg.showError(DefaultKeyManagerFactory.class, null, (String)"Set KeyStore Failed", (Object)"PKI KeyStore was set via system property and can not be changed");
            return false;
        }
        path = DefaultKeyManagerFactory.prunePath(path);
        try {
            boolean keyInitialized = keyManagerWrapper.init(path);
            if (savePreference && (path == null || keyInitialized)) {
                Preferences.setProperty(KEYSTORE_PATH_PROPERTY, path);
                Preferences.store();
            }
            return keyInitialized;
        }
        catch (CancelledException e) {
            return false;
        }
    }

    public static synchronized boolean usingGeneratedSelfSignedCertificate() {
        return keyManagerWrapper.usingGeneratedSelfSignedCertificate();
    }

    public static synchronized void setDefaultIdentity(X500Principal identity) {
        defaultIdentity = identity;
        keyManagerWrapper.invalidateKey();
    }

    public static synchronized void addSubjectAlternativeName(String subjectAltName) {
        if (subjectAltName == null) {
            defaultSubjectAlternativeNames = null;
        } else {
            if (defaultSubjectAlternativeNames == null) {
                defaultSubjectAlternativeNames = new ArrayList<String>();
            }
            defaultSubjectAlternativeNames.add(subjectAltName);
        }
        keyManagerWrapper.invalidateKey();
    }

    public static synchronized boolean initialize() {
        try {
            return keyManagerWrapper.init();
        }
        catch (CancelledException e) {
            return false;
        }
    }

    public static synchronized void invalidateKeyManager() {
        keyManagerWrapper.invalidateKey();
    }

    public static synchronized String getPreferredKeyStore() {
        String path = DefaultKeyManagerFactory.prunePath(System.getProperty(KEYSTORE_PATH_PROPERTY));
        if (path == null && !SystemUtilities.isInHeadlessMode()) {
            path = DefaultKeyManagerFactory.prunePath(Preferences.getProperty(KEYSTORE_PATH_PROPERTY));
        }
        return path;
    }

    public static synchronized String getKeyStore() {
        return keyManagerWrapper.getKeyStore();
    }

    public static synchronized X509ExtendedKeyManager getKeyManager() {
        return keyManagerWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignedToken getSignedToken(Principal[] authorities, byte[] token) throws NoSuchAlgorithmException, SignatureException, CertificateException {
        Destroyable privateKey = null;
        X509Certificate[] certificateChain = null;
        try {
            String alias;
            X509ExtendedKeyManager x509KeyManager = DefaultKeyManagerFactory.getKeyManager();
            if (x509KeyManager != null && (alias = x509KeyManager.chooseClientAlias(new String[]{"RSA"}, authorities, null)) != null) {
                privateKey = x509KeyManager.getPrivateKey(alias);
                certificateChain = x509KeyManager.getCertificateChain(alias);
            }
            if (privateKey == null || certificateChain == null) {
                CertificateException e = new CertificateException("suitable PKI certificate not found");
                e.printStackTrace();
                throw e;
            }
            String algorithm = certificateChain[0].getSigAlgName();
            Signature sig = Signature.getInstance(algorithm);
            try {
                sig.initSign((PrivateKey)privateKey);
            }
            catch (InvalidKeyException e) {
                throw new CertificateException("suitable PKI certificate not found", e);
            }
            sig.update(token);
            SignedToken signedToken = new SignedToken(token, sig.sign(), certificateChain, algorithm);
            return signedToken;
        }
        finally {
            if (privateKey != null) {
                try {
                    privateKey.destroy();
                }
                catch (DestroyFailedException destroyFailedException) {}
            }
        }
    }

    public static boolean isMySignature(Principal[] authorities, byte[] token, byte[] signature) throws NoSuchAlgorithmException, SignatureException, CertificateException {
        SignedToken signedToken = DefaultKeyManagerFactory.getSignedToken(authorities, token);
        return Arrays.equals(signature, signedToken.signature);
    }

    static {
        keyManagerWrapper = new DefaultX509KeyManager();
    }

    private static class DefaultX509KeyManager
    extends X509ExtendedKeyManager {
        private X509KeyManager wrappedKeyManager;
        private String keystorePath;
        private boolean isSelfSigned = false;

        private DefaultX509KeyManager() {
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            return super.chooseEngineServerAlias(keyType, issuers, engine);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return super.chooseEngineClientAlias(keyType, issuers, engine);
        }

        @Override
        public synchronized String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            try {
                this.init();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.chooseClientAlias(keyType, issuers, socket);
        }

        @Override
        public synchronized String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            try {
                this.init();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            try {
                this.init();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            try {
                this.init();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.getServerAliases(keyType, issuers);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.getPrivateKey(alias);
        }

        private synchronized void invalidateKey() {
            this.wrappedKeyManager = null;
            this.keystorePath = null;
            this.isSelfSigned = false;
        }

        private synchronized String getKeyStore() {
            return this.keystorePath != null ? this.keystorePath : DefaultKeyManagerFactory.getPreferredKeyStore();
        }

        private synchronized boolean usingGeneratedSelfSignedCertificate() {
            return this.wrappedKeyManager != null && this.isSelfSigned;
        }

        private synchronized boolean init() throws CancelledException {
            if (this.wrappedKeyManager != null) {
                return true;
            }
            return this.init(DefaultKeyManagerFactory.getPreferredKeyStore());
        }

        private synchronized boolean init(String newKeystorePath) throws CancelledException {
            if (this.wrappedKeyManager != null) {
                if (StringUtils.equals((CharSequence)this.keystorePath, (CharSequence)newKeystorePath)) {
                    return true;
                }
                this.invalidateKey();
            }
            this.isSelfSigned = false;
            try {
                if (newKeystorePath != null && newKeystorePath.length() != 0) {
                    Msg.info(DefaultKeyManagerFactory.class, (Object)("Using certificate keystore: " + newKeystorePath));
                    String keystorePwd = System.getProperty(DefaultKeyManagerFactory.KEYSTORE_PASSWORD_PROPERTY);
                    this.wrappedKeyManager = ApplicationKeyManagerFactory.getKeyManager(newKeystorePath, keystorePwd);
                    this.keystorePath = newKeystorePath;
                } else if (defaultIdentity != null) {
                    Msg.info((Object)this, (Object)("Using self-signed certificate: " + defaultIdentity.getName()));
                    char[] pwd = DefaultKeyManagerFactory.DEFAULT_PASSWORD.toCharArray();
                    KeyStore selfSignedKeyStore = PKIUtils.createKeyStore("defaultSigKey", defaultIdentity.getName(), 730, null, null, "JKS", defaultSubjectAlternativeNames, pwd);
                    this.wrappedKeyManager = ApplicationKeyManagerFactory.getKeyManagerFromKeyStore(selfSignedKeyStore, pwd);
                    this.isSelfSigned = true;
                } else {
                    return false;
                }
                return true;
            }
            catch (CancelledException e) {
                throw e;
            }
            catch (Exception e) {
                Msg.showError((Object)this, null, (String)"PKI Keystore Failure", (Object)("Failed to create PKI key manager: " + e.getMessage()), (Throwable)e);
                return false;
            }
        }
    }
}

