/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.DataTypeSymbol;
import ghidra.program.model.pcode.DynamicEntry;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.pcode.FunctionPrototype;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PartialUnion;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.pcode.UnionFacetSymbol;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.UsrException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class HighFunctionDBUtil {
    public static final String AUTO_CAT = "/auto_proto";

    private static String getPrototypeModelForCommit(HighFunction highFunction) {
        PrototypeModel model;
        String modelName;
        FunctionPrototype prototype = highFunction.getFunctionPrototype();
        String string = modelName = prototype != null ? prototype.getModelName() : null;
        if (modelName != null) {
            if (modelName.equals("unknown")) {
                modelName = null;
            } else if (null == highFunction.getCompilerSpec().getCallingConvention(modelName)) {
                modelName = null;
            }
        }
        if (modelName == null && (model = highFunction.getCompilerSpec().getDefaultCallingConvention()) != null) {
            modelName = model.getName();
        }
        return modelName;
    }

    public static void commitParamsToDatabase(HighFunction highFunction, boolean useDataTypes, ReturnCommitOption returnCommit, SourceType source) throws DuplicateNameException, InvalidInputException {
        boolean customStorageReqd;
        Function function = highFunction.getFunction();
        Parameter returnParam = returnCommit == ReturnCommitOption.NO_COMMIT ? function.getReturn() : HighFunctionDBUtil.getReturnParameter(highFunction, useDataTypes, returnCommit);
        List<Parameter> params = HighFunctionDBUtil.getParameters(highFunction, useDataTypes);
        boolean hasVarArgs = highFunction.getFunctionPrototype().isVarArg();
        String modelName = HighFunctionDBUtil.getPrototypeModelForCommit(highFunction);
        try {
            function.updateFunction(modelName, (Variable)returnParam, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, source);
        }
        catch (DuplicateNameException e) {
            for (Variable variable : params) {
                HighFunctionDBUtil.changeConflictingSymbolNames(variable.getName(), returnParam, function);
            }
            function.updateFunction(modelName, null, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, source);
        }
        boolean bl = customStorageReqd = !VariableUtilities.storageMatches(params, function.getParameters());
        if (returnCommit != ReturnCommitOption.NO_COMMIT) {
            customStorageReqd |= !returnParam.getVariableStorage().equals(function.getReturn().getVariableStorage());
        }
        if (customStorageReqd) {
            function.updateFunction(modelName, (Variable)returnParam, params, Function.FunctionUpdateType.CUSTOM_STORAGE, true, source);
        }
        if (function.hasVarArgs() != hasVarArgs) {
            function.setVarArgs(hasVarArgs);
        }
    }

    private static Parameter getReturnParameter(HighFunction highFunction, boolean useDataTypes, ReturnCommitOption returnCommit) throws InvalidInputException {
        Function function = highFunction.getFunction();
        if (returnCommit == ReturnCommitOption.NO_COMMIT) {
            return function.getReturn();
        }
        Program program = function.getProgram();
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        VariableStorage returnStorage = highFunction.getFunctionPrototype().getReturnStorage();
        DataType returnDt = highFunction.getFunctionPrototype().getReturnType();
        if (useDataTypes && returnCommit == ReturnCommitOption.COMMIT_NO_VOID && returnDt instanceof VoidDataType) {
            return function.getReturn();
        }
        if (returnDt == null) {
            returnDt = DefaultDataType.dataType;
            returnStorage = VariableStorage.UNASSIGNED_STORAGE;
        } else if (!useDataTypes) {
            returnDt = Undefined.getUndefinedDataType(returnDt.getLength()).clone(dtm);
        }
        return new ReturnParameterImpl(returnDt, returnStorage, program);
    }

    private static List<Parameter> getParameters(HighFunction highFunction, boolean useDataTypes) throws InvalidInputException {
        Function function = highFunction.getFunction();
        Program program = function.getProgram();
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        LocalSymbolMap symbolMap = highFunction.getLocalSymbolMap();
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        int paramCnt = symbolMap.getNumParams();
        for (int i = 0; i < paramCnt; ++i) {
            DataType dataType;
            HighSymbol param = symbolMap.getParamSymbol(i);
            String name = param.getName();
            if (useDataTypes) {
                dataType = param.getDataType();
            } else {
                dataType = Undefined.getUndefinedDataType(param.getSize());
                dataType = dataType.clone(dtm);
            }
            params.add(new ParameterImpl(name, dataType, param.getStorage(), program));
        }
        return params;
    }

    private static void changeConflictingSymbolNames(String name, Variable ignoreVariable, Function func) {
        Object newName = name;
        Symbol sym = func.getProgram().getSymbolTable().getVariableSymbol((String)newName, func);
        if (sym == null || sym.isDynamic()) {
            return;
        }
        if (ignoreVariable != null && sym.equals(ignoreVariable.getSymbol())) {
            return;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            newName = name + "_" + i;
            try {
                sym.setName((String)newName, sym.getSource());
                break;
            }
            catch (DuplicateNameException duplicateNameException) {
                continue;
            }
            catch (InvalidInputException e) {
                break;
            }
        }
    }

    public static void commitLocalNamesToDatabase(HighFunction highFunction, SourceType source) {
        Function function = highFunction.getFunction();
        HighFunctionDBUtil.clearObsoleteDynamicLocalsFromDatabase(highFunction);
        Iterator<HighSymbol> iter = highFunction.getLocalSymbolMap().getSymbols();
        while (iter.hasNext()) {
            HighSymbol sym = iter.next();
            if (sym.isParameter() || sym.isGlobal()) continue;
            String name = sym.getName();
            try {
                HighFunctionDBUtil.updateDBVariable(sym, null, null, source);
            }
            catch (UsrException e) {
                Msg.error(HighFunctionDBUtil.class, (Object)("Local variable commit failed for " + function.getName() + ":" + name + " : " + e.getMessage()));
            }
        }
    }

    private static Variable createLocalVariable(Function function, DataType dt, VariableStorage storage, Address pcAddr, SourceType source) throws InvalidInputException {
        Program program = function.getProgram();
        int firstUseOffset = 0;
        if (pcAddr != null) {
            firstUseOffset = (int)pcAddr.subtract(function.getEntryPoint());
        }
        Variable var = new LocalVariableImpl(null, firstUseOffset, dt, storage, program);
        try {
            var = function.addLocalVariable(var, source);
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Unexpected exception with default name", (Throwable)e);
        }
        Register reg = var.getRegister();
        if (reg != null) {
            program.getReferenceManager().addRegisterReference(pcAddr, -1, reg, RefType.WRITE, source);
        }
        return var;
    }

    private static void clearObsoleteDynamicLocalsFromDatabase(HighFunction highFunction) {
        Variable[] variables;
        Function function = highFunction.getFunction();
        for (Variable var : variables = function.getLocalVariables()) {
            if (!var.isUniqueVariable() || HighFunctionDBUtil.isValidUniqueVariable(highFunction, var)) continue;
            function.removeVariable(var);
        }
    }

    private static boolean isValidUniqueVariable(HighFunction highFunction, Variable var) {
        if (!var.isUniqueVariable()) {
            return false;
        }
        long hash = var.getFirstStorageVarnode().getOffset();
        Iterator<HighSymbol> symbols = highFunction.getLocalSymbolMap().getSymbols();
        while (symbols.hasNext()) {
            HighSymbol symbol = symbols.next();
            SymbolEntry entry = symbol.getFirstWholeMap();
            if (!(entry instanceof DynamicEntry) || ((DynamicEntry)entry).getHash() != hash || symbol.getHighVariable() == null) continue;
            return true;
        }
        return false;
    }

    private static Variable[] gatherMergeSet(Function function, Variable seed) {
        Variable[] res;
        TreeMap<String, Variable> nameMap = new TreeMap<String, Variable>();
        for (Variable var : function.getAllVariables()) {
            nameMap.put(var.getName(), var);
        }
        String baseName = seed.getName();
        int pos = baseName.lastIndexOf(36);
        if (pos >= 0) {
            baseName = baseName.substring(0, pos);
        }
        DataType dataType = seed.getDataType();
        Variable currentVar = (Variable)nameMap.get(baseName);
        int index = 0;
        boolean sawSeed = false;
        ArrayList<Variable> mergeArray = new ArrayList<Variable>();
        while (!(currentVar == null || !currentVar.getDataType().equals(dataType) || index != 0 && currentVar instanceof Parameter || index != 0 && currentVar.hasStackStorage())) {
            if (currentVar == seed) {
                sawSeed = true;
            }
            mergeArray.add(currentVar);
            String newName = baseName + "$" + Integer.toString(++index);
            currentVar = (Variable)nameMap.get(newName);
        }
        if (!sawSeed) {
            res = new Variable[]{seed};
        } else {
            res = new Variable[mergeArray.size()];
            mergeArray.toArray(res);
        }
        return res;
    }

    private static Variable getLocalVariable(Function function, VariableStorage storage, Address pcAddr) {
        if (storage.isHashStorage()) {
            long hashVal = storage.getFirstVarnode().getOffset();
            for (Variable ul : function.getLocalVariables(VariableFilter.UNIQUE_VARIABLE_FILTER)) {
                if (ul.getFirstStorageVarnode().getOffset() != hashVal) continue;
                return ul;
            }
            return null;
        }
        int firstUseOffset = 0;
        if (pcAddr != null) {
            firstUseOffset = (int)pcAddr.subtract(function.getEntryPoint());
        }
        for (Variable otherVar : function.getLocalVariables()) {
            VariableStorage otherStorage;
            if (otherVar.getFirstUseOffset() != firstUseOffset || !(otherStorage = otherVar.getVariableStorage()).intersects(storage) || !otherStorage.equals(storage)) continue;
            return otherVar;
        }
        return null;
    }

    private static Variable clearConflictingLocalVariables(Function function, VariableStorage storage, Address pcAddr) {
        int firstUseOffset = 0;
        if (pcAddr != null) {
            firstUseOffset = (int)pcAddr.subtract(function.getEntryPoint());
        }
        if (storage.isHashStorage()) {
            long hashVal = storage.getFirstVarnode().getOffset();
            for (Variable ul : function.getLocalVariables(VariableFilter.UNIQUE_VARIABLE_FILTER)) {
                if (ul.getFirstStorageVarnode().getOffset() != hashVal) continue;
                return ul;
            }
            return null;
        }
        Variable matchingVariable = null;
        for (Variable otherVar : function.getLocalVariables()) {
            VariableStorage otherStorage;
            if (otherVar.getFirstUseOffset() != firstUseOffset || !(otherStorage = otherVar.getVariableStorage()).intersects(storage)) continue;
            if (matchingVariable == null && otherStorage.equals(storage)) {
                matchingVariable = otherVar;
                continue;
            }
            function.removeVariable(otherVar);
        }
        return matchingVariable;
    }

    private static Parameter getDatabaseParameter(HighSymbol param) throws InvalidInputException {
        Parameter[] parameters;
        HighFunction highFunction = param.getHighFunction();
        Function function = highFunction.getFunction();
        int slot = param.getCategoryIndex();
        if (slot < (parameters = function.getParameters()).length && parameters[slot].isAutoParameter()) {
            throw new InvalidInputException("Cannot modify auto-parameter: " + parameters[slot].getName());
        }
        if (slot >= parameters.length || !parameters[slot].getVariableStorage().equals(param.getStorage())) {
            try {
                HighFunctionDBUtil.commitParamsToDatabase(highFunction, true, ReturnCommitOption.NO_COMMIT, SourceType.ANALYSIS);
            }
            catch (DuplicateNameException e) {
                throw new AssertException("Unexpected exception", (Throwable)e);
            }
            parameters = function.getParameters();
            if (slot >= parameters.length || !parameters[slot].getVariableStorage().equals(param.getStorage())) {
                throw new InvalidInputException("Parameter commit failed for function at " + String.valueOf(function.getEntryPoint()));
            }
        }
        return parameters[slot];
    }

    public static Variable getFunctionVariable(HighSymbol highSymbol) {
        if (highSymbol == null) {
            return null;
        }
        HighFunction highFunction = highSymbol.getHighFunction();
        Function function = highFunction.getFunction();
        HighVariable highVar = highSymbol.getHighVariable();
        if (highSymbol.isParameter()) {
            int slot = ((HighParam)highVar).getSlot();
            Parameter parameter = function.getParameter(slot);
            return parameter;
        }
        if (highSymbol.isGlobal()) {
            return null;
        }
        VariableStorage storage = highSymbol.getStorage();
        Address pcAddr = highSymbol.getPCAddress();
        Variable localVariable = HighFunctionDBUtil.getLocalVariable(function, storage, pcAddr);
        if (!storage.isHashStorage() && highVar != null && highVar.requiresDynamicStorage()) {
            DynamicEntry entry = DynamicEntry.build(highVar.getRepresentative());
            storage = entry.getStorage();
            pcAddr = entry.getPCAdress();
        }
        if (localVariable != null) {
            return localVariable;
        }
        return null;
    }

    public static void updateDBVariable(HighSymbol highSymbol, String name, DataType dataType, SourceType source) throws InvalidInputException, DuplicateNameException {
        block36: {
            boolean isRename;
            HighFunction highFunction = highSymbol.getHighFunction();
            Function function = highFunction.getFunction();
            Program program = function.getProgram();
            boolean resized = false;
            if (dataType != null) {
                if ((dataType = dataType.clone(program.getDataTypeManager())).getLength() <= 0) {
                    throw new InvalidInputException("Data type is not fixed-length: " + dataType.getName());
                }
                resized = dataType.getLength() != highSymbol.getSize();
            }
            boolean bl = isRename = name != null;
            if (highSymbol.isParameter()) {
                Parameter dbParam = HighFunctionDBUtil.getDatabaseParameter(highSymbol);
                VariableStorage storage = highSymbol.getStorage();
                if (dataType != null) {
                    if (resized && function.hasCustomVariableStorage()) {
                        VariableStorage newStorage = VariableUtilities.resizeStorage(storage, dataType, true, function);
                        dbParam.setDataType(dataType, newStorage, false, source);
                    } else {
                        dbParam.setDataType(dataType, source);
                    }
                }
                if (name != null && !name.equals(dbParam.getName())) {
                    dbParam.setName(name, source);
                }
            } else if (!highSymbol.isGlobal()) {
                Variable[] varList = null;
                VariableStorage storage = highSymbol.getStorage();
                Address pcAddr = highSymbol.getPCAddress();
                HighVariable tmpHigh = highSymbol.getHighVariable();
                if (!storage.isHashStorage() && tmpHigh != null && tmpHigh.requiresDynamicStorage()) {
                    DynamicEntry entry = DynamicEntry.build(tmpHigh.getRepresentative());
                    storage = entry.getStorage();
                    pcAddr = entry.getPCAdress();
                } else {
                    Variable var = HighFunctionDBUtil.clearConflictingLocalVariables(function, storage, pcAddr);
                    if (var != null) {
                        varList = !resized ? HighFunctionDBUtil.gatherMergeSet(function, var) : new Variable[]{var};
                    }
                }
                boolean usesHashStorage = storage.isHashStorage();
                if (dataType == null) {
                    if (varList != null) {
                        dataType = varList[0].getDataType();
                    } else {
                        dataType = Undefined.getUndefinedDataType(highSymbol.getSize());
                        dataType = dataType.clone(program.getDataTypeManager());
                    }
                }
                if (resized) {
                    if (usesHashStorage) {
                        throw new InvalidInputException("Variable size (" + highSymbol.getSize() + ") may not be changed: type '" + dataType.getName() + "' length is " + dataType.getLength());
                    }
                    storage = VariableUtilities.resizeStorage(storage, dataType, true, function);
                }
                if (varList == null) {
                    Variable variable = HighFunctionDBUtil.createLocalVariable(function, dataType, storage, pcAddr, source);
                    varList = new Variable[]{variable};
                } else if (resized) {
                    varList[0].setDataType(dataType, storage, true, source);
                } else {
                    for (Variable var : varList) {
                        var.setDataType(dataType, source);
                    }
                }
                if (name == null) {
                    name = highSymbol.getName();
                }
                Variable variable = null;
                try {
                    int index = 0;
                    Object curName = name;
                    Variable[] variableArray = varList;
                    int n = variableArray.length;
                    for (int i = 0; i < n; ++i) {
                        Variable var;
                        Variable variable2 = var = variableArray[i];
                        var.setName((String)curName, source);
                        curName = name + "$" + Integer.toString(++index);
                    }
                }
                catch (DuplicateNameException e) {
                    if (isRename) {
                        throw e;
                    }
                    try {
                        Msg.error(HighFunctionDBUtil.class, (Object)("Name conflict while naming local variable: " + function.getName() + ":" + name));
                        variable.setName(null, SourceType.DEFAULT);
                    }
                    catch (DuplicateNameException e1) {
                        throw new AssertException("Unexpected exception with default name", (Throwable)e);
                    }
                }
            } else {
                VariableStorage storage = highSymbol.getStorage();
                if (!storage.isMemoryStorage()) {
                    throw new UnsupportedOperationException("Database supports global memory variables only");
                }
                if (name == null && (name = highSymbol.getName()) != null && SymbolUtilities.isDynamicSymbolPattern(name, true)) {
                    name = null;
                }
                if (dataType != null) {
                    HighFunctionDBUtil.setGlobalDataType(highSymbol, dataType);
                }
                if (name != null) {
                    try {
                        HighFunctionDBUtil.setGlobalName(highSymbol, name, source);
                    }
                    catch (DuplicateNameException e) {
                        if (!isRename) break block36;
                        throw e;
                    }
                }
            }
        }
    }

    private static void setGlobalName(HighSymbol global, String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        Program program = global.getHighFunction().getFunction().getProgram();
        VariableStorage storage = global.getStorage();
        if (!storage.isMemoryStorage()) {
            return;
        }
        Address addr = storage.getFirstVarnode().getAddress();
        SymbolTable symTable = program.getSymbolTable();
        Symbol sym = symTable.getPrimarySymbol(addr);
        if (sym == null) {
            symTable.createLabel(addr, name, source);
        } else if (!sym.getName().equals(name)) {
            sym.setName(name, source);
        }
    }

    private static Data setGlobalDataType(HighSymbol global, DataType dt) throws InvalidInputException {
        Program program = global.getHighFunction().getFunction().getProgram();
        VariableStorage storage = global.getStorage();
        if (!storage.isMemoryStorage()) {
            return null;
        }
        Address addr = storage.getFirstVarnode().getAddress();
        Listing listing = program.getListing();
        Data d = listing.getDataAt(addr);
        if (d != null && d.getDataType().isEquivalent(dt)) {
            return d;
        }
        try {
            return DataUtilities.createData(program, addr, dt, -1, DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
        }
        catch (CodeUnitInsertionException e) {
            throw new InvalidInputException(e.getMessage());
        }
    }

    public static void writeOverride(Function function, Address callsite, FunctionSignature sig) throws InvalidInputException {
        ParameterDefinition[] params = sig.getArguments();
        FunctionDefinitionDataType fsig = new FunctionDefinitionDataType("tmpname", (DataTypeManager)function.getProgram().getDataTypeManager());
        fsig.setCallingConvention(sig.getCallingConventionName());
        fsig.setArguments(params);
        fsig.setReturnType(sig.getReturnType());
        fsig.setVarArgs(sig.hasVarArgs());
        fsig.setNoReturn(sig.hasNoReturn());
        DataTypeSymbol datsym = new DataTypeSymbol(fsig, "prt", AUTO_CAT);
        Program program = function.getProgram();
        SymbolTable symtab = program.getSymbolTable();
        ProgramBasedDataTypeManager dtmanage = program.getDataTypeManager();
        Namespace space = HighFunction.findCreateOverrideSpace(function);
        if (space == null) {
            throw new InvalidInputException("Could not create \"override\" namespace");
        }
        datsym.writeSymbol(symtab, callsite, space, dtmanage, true);
    }

    public static DataTypeSymbol readOverride(Symbol sym) {
        DataTypeSymbol datsym = DataTypeSymbol.readSymbol(AUTO_CAT, sym);
        if (datsym == null) {
            return null;
        }
        DataType dt = datsym.getDataType();
        if (!(dt instanceof FunctionSignature)) {
            return null;
        }
        return datsym;
    }

    public static int getFirstVarArg(Program program, Address addr) {
        for (Reference ref : program.getReferenceManager().getReferencesFrom(addr)) {
            if (!ref.isPrimary() || !ref.getReferenceType().isCall()) continue;
            Address callDestAddr = ref.getToAddress();
            Function func = program.getFunctionManager().getFunctionAt(callDestAddr);
            if (func == null || !func.hasVarArgs()) break;
            return func.getParameterCount();
        }
        return -1;
    }

    public static Address getSpacebaseReferenceAddress(AddressFactory addrFactory, PcodeOp op) {
        Address storageAddress = null;
        if (op == null) {
            return storageAddress;
        }
        if (op.getOpcode() == 66) {
            Varnode vnode = op.getInput(0);
            Varnode cnode = op.getInput(1);
            if (vnode.isRegister()) {
                AddressSpace stackspace = addrFactory.getStackSpace();
                if (stackspace != null) {
                    storageAddress = stackspace.getAddress(cnode.getOffset());
                }
            } else {
                AddressSpace space = addrFactory.getDefaultAddressSpace();
                if (space instanceof SegmentedAddressSpace) {
                    int innersize = space.getPointerSize();
                    int base = (int)(cnode.getOffset() >>> 8 * innersize);
                    int off = (int)cnode.getOffset() & (1 << 8 * innersize) - 1;
                    storageAddress = ((SegmentedAddressSpace)space).getAddress(base, off);
                } else {
                    storageAddress = space.getAddress(cnode.getOffset());
                }
            }
        }
        return storageAddress;
    }

    public static void writeUnionFacet(Function function, DataType dt, int fieldNum, Address addr, long hash, SourceType source) throws InvalidInputException, DuplicateNameException {
        if (dt instanceof PartialUnion) {
            dt = ((PartialUnion)dt).getParent();
        }
        int firstUseOffset = (int)addr.subtract(function.getEntryPoint());
        Object symbolName = UnionFacetSymbol.buildSymbolName(fieldNum, addr);
        boolean nameCollision = false;
        Variable[] localVariables = function.getLocalVariables(VariableFilter.UNIQUE_VARIABLE_FILTER);
        for (int i = 0; i < localVariables.length; ++i) {
            Variable[] var = localVariables[i];
            if (!var.getName().startsWith(UnionFacetSymbol.BASENAME) || UnionFacetSymbol.isUnionType(var.getDataType())) continue;
            function.removeVariable((Variable)var);
            localVariables[i] = null;
        }
        Variable preexistingVar = null;
        for (Variable var : localVariables) {
            if (var == null) continue;
            if (var.getFirstUseOffset() == firstUseOffset && var.getFirstStorageVarnode().getOffset() == hash) {
                preexistingVar = var;
                continue;
            }
            if (!var.getName().startsWith((String)symbolName)) continue;
            nameCollision = true;
        }
        if (nameCollision) {
            symbolName = (String)symbolName + "_" + Integer.toHexString(DynamicHash.getComparable(hash));
        }
        if (preexistingVar != null) {
            if (!preexistingVar.getName().equals(symbolName)) {
                preexistingVar.setName((String)symbolName, source);
            }
            if (!preexistingVar.getDataType().equals(dt)) {
                preexistingVar.setDataType(dt, source);
            }
            return;
        }
        Program program = function.getProgram();
        VariableStorage storage = new VariableStorage((ProgramArchitecture)program, AddressSpace.HASH_SPACE.getAddress(hash), dt.getLength());
        LocalVariableImpl var = new LocalVariableImpl((String)symbolName, firstUseOffset, dt, storage, program);
        function.addLocalVariable(var, SourceType.USER_DEFINED);
    }

    public static enum ReturnCommitOption {
        NO_COMMIT,
        COMMIT,
        COMMIT_NO_VOID;

    }
}

