/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import org.gradle.cache.Cache;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.DeferredExecutionAwareStep;
import org.gradle.internal.execution.steps.ExecutionRequestContext;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.snapshot.ValueSnapshot;

public class IdentifyStep<C extends ExecutionRequestContext, R extends Result>
extends BuildOperationStep<C, R>
implements DeferredExecutionAwareStep<C, R> {
    private final DeferredExecutionAwareStep<? super IdentityContext, R> delegate;

    public IdentifyStep(BuildOperationRunner buildOperationRunner, DeferredExecutionAwareStep<? super IdentityContext, R> delegate) {
        super(buildOperationRunner);
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        return this.delegate.execute(work, this.createIdentityContext(work, context));
    }

    @Override
    public <T> Deferrable<Try<T>> executeDeferred(UnitOfWork work, C context, Cache<UnitOfWork.Identity, ExecutionEngine.IdentityCacheResult<T>> cache) {
        return this.delegate.executeDeferred(work, this.createIdentityContext(work, context), cache);
    }

    private IdentityContext createIdentityContext(UnitOfWork work, C context) {
        InputFingerprinter.Result inputs = work.getInputFingerprinter().fingerprintInputProperties((ImmutableSortedMap<String, ValueSnapshot>)ImmutableSortedMap.of(), (ImmutableSortedMap<String, ? extends FileCollectionFingerprint>)ImmutableSortedMap.of(), (ImmutableSortedMap<String, ValueSnapshot>)ImmutableSortedMap.of(), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)ImmutableSortedMap.of(), work::visitIdentityInputs, work.getInputDependencyChecker(((ExecutionRequestContext)context).getValidationContext()));
        ImmutableSortedMap<String, ValueSnapshot> identityInputProperties = inputs.getValueSnapshots();
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> identityInputFileProperties = inputs.getFileFingerprints();
        UnitOfWork.Identity identity = work.identify((Map<String, ValueSnapshot>)identityInputProperties, (Map<String, CurrentFileCollectionFingerprint>)identityInputFileProperties);
        return new IdentityContext((ExecutionRequestContext)context, identityInputProperties, identityInputFileProperties, identity);
    }
}

